<?php
// app/Views/admin/taxi_bookings_new.php
$title = $title ?? 'Taxi Bookings';
$rows = $rows ?? [];
$filters = $filters ?? [];
$csrf = $csrf ?? '';
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?= htmlspecialchars($title) ?> - Admin</title>
    
    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <!-- Bootstrap Icons -->
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.0/font/bootstrap-icons.css">
    
    <style>
        :root {
            --primary: #4e73df;
            --primary-hover: #2e59d9;
            --secondary: #858796;
            --success: #1cc88a;
            --info: #36b9cc;
            --warning: #f6c23e;
            --danger: #e74a3b;
            --light: #f8f9fc;
            --dark: #5a5c69;
        }
        
        body {
            background-color: #f8f9fc;
            font-size: 0.9rem;
        }
        
        /* Card Styling */
        .card {
            border: none;
            box-shadow: 0 0.15rem 1.75rem 0 rgba(58, 59, 69, 0.15);
            margin-bottom: 1.5rem;
        }
        
        .card-header {
            background-color: #fff;
            border-bottom: 1px solid #e3e6f0;
            padding: 1rem 1.25rem;
        }
        
        .card-title {
            font-weight: 600;
            color: #4a4b65;
            margin-bottom: 0;
        }
        
        /* Table Styling */
        .table {
            margin-bottom: 0;
        }
        
        .table th {
            background-color: #f8f9fc;
            border-top: none;
            border-bottom: 2px solid #e3e6f0;
            font-weight: 600;
            color: #4a5568;
            text-transform: uppercase;
            font-size: 0.7rem;
            letter-spacing: 0.5px;
            padding: 0.75rem 1rem;
            white-space: nowrap;
            vertical-align: middle;
        }
        
        .table td {
            padding: 1rem;
            vertical-align: middle;
            border-color: #eaecf4;
        }
        
        .table-hover > tbody > tr:hover > * {
            background-color: #f8fafc;
        }
        
        .badge {
            font-weight: 500;
            padding: 0.35em 0.65em;
            font-size: 0.75em;
            letter-spacing: 0.5px;
        }
        
        .btn-action {
            width: 32px;
            height: 32px;
            display: inline-flex;
            align-items: center;
            justify-content: center;
            padding: 0;
            border-radius: 50%;
        }
        
        .btn-sm {
            font-size: 0.8rem;
        }
        
        .badge-status {
            padding: 0.5em 0.8em;
            border-radius: 0.35rem;
            font-weight: 500;
        }
        
        @media (max-width: 768px) {
            .table-responsive {
                border: none;
            }
            
            .card-header {
                flex-direction: column;
                align-items: flex-start !important;
                gap: 1rem;
            }
        }
    </style>
</head>
<body>
    <div class="container-fluid py-4">
        <!-- Page Header -->
        <div class="d-flex justify-content-between align-items-center mb-4">
            <div>
                <h1 class="h4 mb-0 text-gray-800">
                    <i class="bi bi-taxi-front me-2"></i>Taxi Bookings
                </h1>
                <nav aria-label="breadcrumb">
                    <ol class="breadcrumb mb-0 mt-2">
                        <li class="breadcrumb-item"><a href="/admin" class="text-decoration-none">Dashboard</a></li>
                        <li class="breadcrumb-item active" aria-current="page">Taxi Bookings</li>
                    </ol>
                </nav>
            </div>
            <div>
                <a href="/admin/booking/taxi/create" class="btn btn-primary">
                    <i class="bi bi-plus-lg me-1"></i> New Booking
                </a>
            </div>
        </div>

        <!-- Filters Card -->
        <div class="card mb-4">
            <div class="card-header d-flex justify-content-between align-items-center">
                <h6 class="mb-0">Filters</h6>
                <button class="btn btn-sm btn-link text-decoration-none" type="button" data-bs-toggle="collapse" data-bs-target="#filterCollapse">
                    <i class="bi bi-funnel me-1"></i> Toggle Filters
                </button>
            </div>
            <div class="collapse show" id="filterCollapse">
                <div class="card-body">
                    <form id="filterForm" class="row g-3">
                        <div class="col-md-3">
                            <label for="status" class="form-label small fw-bold text-muted">Status</label>
                            <select class="form-select form-select-sm" name="status" id="status">
                                <option value="">All Status</option>
                                <option value="pending">Pending</option>
                                <option value="confirmed">Confirmed</option>
                                <option value="completed">Completed</option>
                                <option value="cancelled">Cancelled</option>
                            </select>
                        </div>
                        <div class="col-md-3">
                            <label for="dateFrom" class="form-label small fw-bold text-muted">From Date</label>
                            <input type="date" class="form-control form-control-sm" id="dateFrom" name="date_from">
                        </div>
                        <div class="col-md-3">
                            <label for="dateTo" class="form-label small fw-bold text-muted">To Date</label>
                            <input type="date" class="form-control form-control-sm" id="dateTo" name="date_to">
                        </div>
                        <div class="col-md-3 d-flex align-items-end">
                            <button type="submit" class="btn btn-primary btn-sm me-2">
                                <i class="bi bi-funnel me-1"></i> Apply
                            </button>
                            <button type="reset" class="btn btn-outline-secondary btn-sm">
                                <i class="bi bi-arrow-counterclockwise me-1"></i> Reset
                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </div>

        <!-- Bookings Table -->
        <div class="card">
            <div class="card-header d-flex justify-content-between align-items-center">
                <h6 class="mb-0">All Bookings</h6>
                <div class="d-flex align-items-center">
                    <div class="input-group input-group-sm me-3" style="width: 200px;">
                        <input type="text" class="form-control" placeholder="Search..." id="searchInput">
                        <button class="btn btn-outline-secondary" type="button">
                            <i class="bi bi-search"></i>
                        </button>
                    </div>
                    <div class="dropdown">
                        <button class="btn btn-sm btn-outline-secondary dropdown-toggle" type="button" id="exportDropdown" data-bs-toggle="dropdown" aria-expanded="false">
                            <i class="bi bi-download me-1"></i> Export
                        </button>
                        <ul class="dropdown-menu dropdown-menu-end" aria-labelledby="exportDropdown">
                            <li><a class="dropdown-item" href="#"><i class="bi bi-file-earmark-excel me-2"></i>Excel</a></li>
                            <li><a class="dropdown-item" href="#"><i class="bi bi-file-earmark-pdf me-2"></i>PDF</a></li>
                            <li><a class="dropdown-item" href="#"><i class="bi bi-printer me-2"></i>Print</a></li>
                        </ul>
                    </div>
                </div>
            </div>
            
            <div class="card-body p-0">
                <div class="table-responsive">
                    <table class="table table-hover align-middle mb-0">
                        <colgroup>
                            <col style="width: 60px;">
                            <col style="min-width: 180px;">
                            <col style="min-width: 180px;">
                            <col style="min-width: 150px;">
                            <col style="min-width: 150px;">
                            <col style="min-width: 150px;">
                            <col style="width: 120px;">
                            <col style="width: 120px;">
                            <col style="width: 140px;">
                        </colgroup>
                        <thead class="bg-light">
                            <tr>
                                <th class="text-center">#</th>
                                <th>Booking</th>
                                <th>Customer</th>
                                <th>Pickup</th>
                                <th>Dropoff</th>
                                <th>Date/Time</th>
                                <th class="text-end">Amount</th>
                                <th class="text-center">Status</th>
                                <th class="text-center">Actions</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php if (!empty($rows)): ?>
                                <?php foreach ($rows as $r): ?>
                                    <tr class="border-bottom">
                                        <td class="text-center fw-semibold"><?= $r['id'] ?? '' ?></td>
                                        <td>
                                            <div class="d-flex align-items-center">
                                                <div class="flex-shrink-0 me-3 bg-light rounded p-2">
                                                    <i class="bi bi-taxi-front-fill text-primary"></i>
                                                </div>
                                                <div class="flex-grow-1">
                                                    <div class="fw-medium mb-1">
                                                        <a href="/admin/booking/taxi/view?id=<?= (int)($r['id'] ?? 0) ?>" class="text-decoration-none text-dark">
                                                            TAX-<?= date('Ymd', strtotime($r['created_at'] ?? 'now')) ?>-<?= $r['id'] ?? '' ?>
                                                        </a>
                                                    </div>
                                                    <div class="text-muted small">
                                                        <i class="bi bi-calendar3 me-1"></i> <?= date('M j, Y H:i', strtotime($r['created_at'] ?? 'now')) ?>
                                                    </div>
                                                </div>
                                            </div>
                                        </td>
                                        <td>
                                            <div class="d-flex align-items-center">
                                                <div class="flex-shrink-0 me-3">
                                                    <div class="bg-light rounded-circle d-flex align-items-center justify-content-center" style="width: 40px; height: 40px;">
                                                        <i class="bi bi-person-fill text-primary"></i>
                                                    </div>
                                                </div>
                                                <div class="flex-grow-1">
                                                    <div class="fw-medium"><?= htmlspecialchars($r['customer_name'] ?? 'N/A') ?></div>
                                                    <div class="text-muted small"><?= htmlspecialchars($r['customer_phone'] ?? 'N/A') ?></div>
                                                </div>
                                            </div>
                                        </td>
                                        <td>
                                            <div class="text-truncate" style="max-width: 200px;" title="<?= htmlspecialchars($r['pickup_location'] ?? 'N/A') ?>">
                                                <?= htmlspecialchars($r['pickup_location'] ?? 'N/A') ?>
                                            </div>
                                        </td>
                                        <td>
                                            <div class="text-truncate" style="max-width: 200px;" title="<?= htmlspecialchars($r['dropoff_location'] ?? 'N/A') ?>">
                                                <?= htmlspecialchars($r['dropoff_location'] ?? 'N/A') ?>
                                            </div>
                                        </td>
                                        <td>
                                            <?php if (!empty($r['trip_date'])): ?>
                                                <div class="fw-medium"><?= date('M j, Y', strtotime($r['trip_date'])) ?></div>
                                                <div class="text-muted small">
                                                    <i class="bi bi-clock me-1"></i> <?= !empty($r['pickup_time']) ? date('H:i', strtotime($r['pickup_time'])) : '--:--' ?>
                                                </div>
                                            <?php else: ?>
                                                <span class="text-muted">N/A</span>
                                            <?php endif; ?>
                                        </td>
                                        <td class="text-end fw-semibold">
                                            <?= number_format($r['amount_total'] ?? 0, 2) ?> <small class="text-muted">THB</small>
                                        </td>
                                        <td class="text-center">
                                            <?php
                                            $status = strtolower($r['status'] ?? 'pending');
                                            $statusClass = [
                                                'confirmed' => 'success',
                                                'completed' => 'primary',
                                                'cancelled' => 'danger',
                                                'pending' => 'warning'
                                            ][$status] ?? 'secondary';
                                            ?>
                                            <span class="badge bg-<?= $statusClass ?>-subtle text-<?= $statusClass ?> px-3 py-2">
                                                <?= ucfirst($status) ?>
                                            </span>
                                        </td>
                                        <td class="text-center">
                                            <div class="d-flex justify-content-center gap-2">
                                                <a href="/admin/booking/taxi/view?id=<?= (int)($r['id'] ?? 0) ?>" 
                                                   class="btn btn-sm btn-outline-primary btn-action"
                                                   data-bs-toggle="tooltip" 
                                                   title="View Details">
                                                    <i class="bi bi-eye-fill"></i>
                                                </a>
                                                <a href="/admin/booking/taxi/edit?id=<?= (int)($r['id'] ?? 0) ?>" 
                                                   class="btn btn-sm btn-outline-secondary btn-action"
                                                   data-bs-toggle="tooltip" 
                                                   title="Edit Booking">
                                                    <i class="bi bi-pencil-fill"></i>
                                                </a>
                                                <button type="button" 
                                                        class="btn btn-sm btn-outline-danger btn-action"
                                                        data-bs-toggle="modal" 
                                                        data-bs-target="#cancelBookingModal" 
                                                        data-booking-id="<?= (int)($r['id'] ?? 0) ?>"
                                                        title="Cancel Booking">
                                                    <i class="bi bi-x-lg"></i>
                                                </button>
                                            </div>
                                        </td>
                                    </tr>
                                <?php endforeach; ?>
                            <?php else: ?>
                                <tr>
                                    <td colspan="9" class="text-center py-5">
                                        <div class="text-muted">
                                            <i class="bi bi-inbox display-6 d-block mb-2"></i>
                                            No bookings found
                                        </div>
                                    </td>
                                </tr>
                            <?php endif; ?>
                        </tbody>
                    </table>
                </div>
            </div>
            
            <!-- Pagination -->
            <?php if (!empty($rows) && ($totalPages ?? 1) > 1): ?>
                <div class="card-footer d-flex justify-content-between align-items-center">
                    <div class="text-muted small">
                        Showing <?= count($rows) ?> of <?= $totalItems ?? 0 ?> entries
                    </div>
                    <nav>
                        <ul class="pagination pagination-sm mb-0">
                            <?php if (($currentPage ?? 1) > 1): ?>
                                <li class="page-item">
                                    <a class="page-link" href="?page=<?= ($currentPage ?? 1) - 1 ?><?= !empty($filters) ? '&' . http_build_query($filters) : '' ?>">
                                        <i class="bi bi-chevron-left"></i>
                                    </a>
                                </li>
                            <?php endif; ?>
                            
                            <?php for ($i = 1; $i <= ($totalPages ?? 1); $i++): ?>
                                <li class="page-item <?= $i === ($currentPage ?? 1) ? 'active' : '' ?>">
                                    <a class="page-link" href="?page=<?= $i ?><?= !empty($filters) ? '&' . http_build_query($filters) : '' ?>">
                                        <?= $i ?>
                                    </a>
                                </li>
                            <?php endfor; ?>
                            
                            <?php if (($currentPage ?? 1) < ($totalPages ?? 1)): ?>
                                <li class="page-item">
                                    <a class="page-link" href="?page=<?= ($currentPage ?? 1) + 1 ?><?= !empty($filters) ? '&' . http_build_query($filters) : '' ?>">
                                        <i class="bi bi-chevron-right"></i>
                                    </a>
                                </li>
                            <?php endif; ?>
                        </ul>
                    </nav>
                </div>
            <?php endif; ?>
        </div>
    </div>

    <!-- Cancel Booking Modal -->
    <div class="modal fade" id="cancelBookingModal" tabindex="-1" aria-labelledby="cancelBookingModalLabel" aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header bg-light">
                    <h5 class="modal-title" id="cancelBookingModalLabel">Cancel Booking</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <form id="cancelBookingForm" action="/admin/booking/taxi/cancel" method="POST">
                    <div class="modal-body">
                        <p>Are you sure you want to cancel this booking? This action cannot be undone.</p>
                        <input type="hidden" name="id" id="cancelBookingId">
                        <?= $csrf ?>
                        <div class="mb-3">
                            <label for="cancelReason" class="form-label">Reason for cancellation</label>
                            <select class="form-select" id="cancelReason" name="reason" required>
                                <option value="">Select a reason</option>
                                <option value="customer_request">Customer Request</option>
                                <option value="no_available_driver">No Available Driver</option>
                                <option value="schedule_conflict">Schedule Conflict</option>
                                <option value="payment_issue">Payment Issue</option>
                                <option value="other">Other Reason</option>
                            </select>
                        </div>
                        <div class="mb-3" id="otherReasonContainer" style="display: none;">
                            <label for="otherReason" class="form-label">Please specify</label>
                            <textarea class="form-control" id="otherReason" name="other_reason" rows="3" placeholder="Enter the reason for cancellation..."></textarea>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">
                            <i class="bi bi-x-circle me-1"></i> Close
                        </button>
                        <button type="submit" class="btn btn-danger">
                            <i class="bi bi-x-lg me-1"></i> Cancel Booking
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <!-- Bootstrap JS -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/js/bootstrap.bundle.min.js"></script>
    
    <script>
    // Initialize tooltips
    document.addEventListener('DOMContentLoaded', function() {
        // Initialize Bootstrap tooltips
        var tooltipTriggerList = [].slice.call(document.querySelectorAll('[data-bs-toggle="tooltip"]'));
        tooltipTriggerList.map(function (tooltipTriggerEl) {
            return new bootstrap.Tooltip(tooltipTriggerEl);
        });

        // Cancel Booking Modal
        var cancelModal = document.getElementById('cancelBookingModal');
        if (cancelModal) {
            cancelModal.addEventListener('show.bs.modal', function (event) {
                var button = event.relatedTarget;
                var bookingId = button.getAttribute('data-booking-id');
                var modal = this;
                modal.querySelector('#cancelBookingId').value = bookingId;
                
                // Reset form when modal is shown
                var form = modal.querySelector('form');
                if (form) {
                    form.reset();
                }
                
                // Hide other reason container by default
                var otherReasonContainer = document.getElementById('otherReasonContainer');
                if (otherReasonContainer) {
                    otherReasonContainer.style.display = 'none';
                }
            });
        }

        // Show/hide other reason field
        var cancelReason = document.getElementById('cancelReason');
        var otherReasonContainer = document.getElementById('otherReasonContainer');
        if (cancelReason && otherReasonContainer) {
            cancelReason.addEventListener('change', function() {
                otherReasonContainer.style.display = this.value === 'other' ? 'block' : 'none';
                if (this.value !== 'other') {
                    document.getElementById('otherReason').value = '';
                }
            });
        }

        // Search functionality
        var searchInput = document.getElementById('searchInput');
        if (searchInput) {
            searchInput.addEventListener('keyup', function(e) {
                if (e.key === 'Enter') {
                    // Add search functionality here
                    console.log('Searching for:', this.value);
                }
            });
        }
    });
    </script>
</body>
</html>
