<?php
// app/Views/admin/taxi_booking_edit.php
$title = $title ?? 'Edit Taxi Booking';
$booking = $booking ?? [];
$csrf = $csrf ?? '';
?>

<div class="container py-3">
  <h2 class="h5 mb-3">
    <a href="/admin/booking/taxi" class="text-decoration-none text-muted">
      <i class="bi bi-arrow-left me-2"></i>
    </a>
    Edit Taxi Booking #<?= htmlspecialchars($booking['booking_code'] ?? '') ?>
  </h2>

  <div class="card shadow-sm border-0">
    <div class="card-body">
      <form id="editBookingForm" method="post" action="/admin/booking/taxi/update">
        <input type="hidden" name="csrf" value="<?= htmlspecialchars($csrf) ?>">
        <input type="hidden" name="id" value="<?= (int)($booking['id'] ?? 0) ?>">
        
        <div class="row g-3">
          <!-- Trip Details -->
          <div class="col-md-6">
            <h5 class="mb-3"><i class="bi bi-geo-alt me-2"></i>Trip Details</h5>
            
            <div class="mb-3">
              <label class="form-label">Trip Date</label>
              <input type="date" class="form-control" name="trip_date" 
                     value="<?= htmlspecialchars($booking['trip_date'] ?? '') ?>" required>
            </div>
            
            <div class="mb-3">
              <label class="form-label">Pickup Time</label>
              <input type="time" class="form-control" name="pickup_time" 
                     value="<?= date('H:i', strtotime($booking['pickup_time'] ?? 'now')) ?>" required>
            </div>
            
            <div class="mb-3">
              <label class="form-label">Number of Passengers</label>
              <input type="number" class="form-control" name="pax" min="1" 
                     value="<?= (int)($booking['pax'] ?? 1) ?>" required>
            </div>
          </div>
          
          <!-- Location Details -->
          <div class="col-md-6">
            <h5 class="mb-3"><i class="bi bi-pin-map me-2"></i>Location Details</h5>
            
            <div class="mb-3">
              <label class="form-label">From</label>
              <input type="text" class="form-control" name="from_text" 
                     value="<?= htmlspecialchars($booking['from_text'] ?? '') ?>" required>
            </div>
            
            <div class="mb-3">
              <label class="form-label">To</label>
              <input type="text" class="form-control" name="to_text" 
                     value="<?= htmlspecialchars($booking['to_text'] ?? '') ?>" required>
            </div>
            
            <div class="mb-3">
              <label class="form-label">Special Instructions</label>
              <textarea class="form-control" name="special_instructions" rows="2"><?= 
                htmlspecialchars($booking['special_instructions'] ?? '') 
              ?></textarea>
            </div>
          </div>
          
          <!-- Customer Details -->
          <div class="col-12">
            <hr class="my-4">
            <h5 class="mb-3"><i class="bi bi-person-lines-fill me-2"></i>Customer Details</h5>
            
            <div class="card">
              <div class="card-body">
                <div class="d-flex align-items-center mb-4">
                  <div class="bg-light p-3 rounded-circle me-3">
                    <i class="bi bi-person-circle fs-3 text-primary"></i>
                  </div>
                  <div class="flex-grow-1">
                    <div class="row g-3">
                      <div class="col-md-6">
                        <label class="form-label">Contact Name</label>
                        <input type="text" class="form-control" name="contact_name" 
                               value="<?= htmlspecialchars($booking['contact_name'] ?? ($booking['customer_name'] ?? '')) ?>" required>
                      </div>
                      
                      <div class="col-md-6">
                        <label class="form-label">Contact Phone</label>
                        <input type="tel" class="form-control" name="contact_phone" 
                               value="<?= htmlspecialchars($booking['contact_phone'] ?? ($booking['customer_mobile'] ?? '')) ?>">
                      </div>
                      
                      <div class="col-md-6">
                        <label class="form-label">Contact Email</label>
                        <input type="email" class="form-control" name="contact_email" 
                               value="<?= htmlspecialchars($booking['contact_email'] ?? ($booking['customer_email'] ?? '')) ?>">
                      </div>
                      
                      <div class="col-12">
                        <label class="form-label">Customer Notes</label>
                        <textarea class="form-control" name="customer_notes" rows="2"><?= 
                          htmlspecialchars($booking['customer_notes'] ?? ($booking['notes'] ?? '')) 
                        ?></textarea>
                      </div>
                    </div>
                  </div>
                </div>
              </div>
          </div>
          
          <!-- Actions -->
          <div class="col-12 mt-4">
            <div class="d-flex justify-content-between">
              <a href="/admin/booking/taxi/view?id=<?= (int)($booking['id'] ?? 0) ?>" 
                 class="btn btn-outline-secondary">
                <i class="bi bi-x-lg me-1"></i> Cancel
              </a>
              <button type="submit" class="btn btn-primary">
                <i class="bi bi-check-lg me-1"></i> Save Changes
              </button>
            </div>
          </div>
        </div>
      </form>
    </div>
  </div>
</div>
