<?php
// app/Views/admin/support_view.php
$title = $title ?? 'Support Ticket';
$ticket = $ticket ?? null;
$replies = $replies ?? [];
$csrf = $csrf ?? '';
$isAdminPage = true;
$showAdminSidebar = true;

// Time formatter function
$fmt = function($ts) { 
    if(!$ts) return '—'; 
    $tm = strtotime((string)$ts); 
    if(!$tm) return '—';
    $now = time();
    $diff = $now - $tm;
    
    // Relative time for recent items
    if($diff < 3600) {
        $mins = floor($diff / 60);
        return $mins <= 1 ? 'just now' : $mins . ' minutes ago';
    } elseif($diff < 86400) {
        $hours = floor($diff / 3600);
        return $hours . ' hour' . ($hours > 1 ? 's' : '') . ' ago';
    } elseif($diff < 604800) {
        $days = floor($diff / 86400);
        return $days . ' day' . ($days > 1 ? 's' : '') . ' ago';
    }
    
    // Full date for older items
    return date('d M Y, H:i', $tm);
};

// Set up any additional head content
$headContent = '<link rel="stylesheet" href="/assets/css/admin.css">';

?>

<div class="container-fluid py-4">
  <style>
    /* Minimal compatibility mappings so this view looks good with Bootstrap only */
    .bg-white { background-color: #fff !important; }
    .rounded-xl { border-radius: 0.75rem !important; }
    .rounded-2xl { border-radius: 1rem !important; }
    .rounded-lg { border-radius: 0.5rem !important; }
    .shadow-sm { box-shadow: var(--bs-box-shadow-sm) !important; }
    .border { border: 1px solid rgba(0,0,0,.125) !important; }
    .border-slate-100 { border-color: rgba(0,0,0,.075) !important; }
    .border-slate-200 { border-color: rgba(0,0,0,.125) !important; }
    .text-slate-900 { color: #212529 !important; }
    .text-slate-800 { color: #343a40 !important; }
    .text-slate-700 { color: #495057 !important; }
    .text-slate-600 { color: #6c757d !important; }
    .text-slate-500 { color: #adb5bd !important; }
    .text-slate-400 { color: #ced4da !important; }
    .mb-6 { margin-bottom: 1.5rem !important; }
    .mb-4 { margin-bottom: 1rem !important; }
    .mt-2 { margin-top: .5rem !important; }
    .mt-4 { margin-top: 1rem !important; }
    .mt-6 { margin-top: 1.5rem !important; }
    .p-2 { padding: .5rem !important; }
    .p-3 { padding: 1rem !important; }
    .p-4 { padding: 1.25rem !important; }
    .p-6 { padding: 1.5rem !important; }
    .px-3 { padding-left: 1rem !important; padding-right: 1rem !important; }
    .px-4 { padding-left: 1.25rem !important; padding-right: 1.25rem !important; }
    .px-5 { padding-left: 1.5rem !important; padding-right: 1.5rem !important; }
    .py-1 { padding-top: .25rem !important; padding-bottom: .25rem !important; }
    .py-2 { padding-top: .5rem !important; padding-bottom: .5rem !important; }
    .py-3 { padding-top: 1rem !important; padding-bottom: 1rem !important; }
    .py-4 { padding-top: 1.25rem !important; padding-bottom: 1.25rem !important; }
    .gap-2 { gap: .5rem !important; }
    .gap-3 { gap: .75rem !important; }
    .gap-4 { gap: 1rem !important; }
    .gap-6 { gap: 1.5rem !important; }
    .flex { display: flex !important; }
    .items-center { align-items: center !important; }
    .justify-between { justify-content: space-between !important; }
    .w-full { width: 100% !important; }
    /* Badge-like helpers */
    .rounded-full { border-radius: 9999px !important; }
  </style>
    <?php if (!$ticket): ?>
      <div class="bg-white rounded-xl p-6 border border-slate-200">Ticket not found.</div>
    <?php else: ?>
    <!-- Header -->
    <div class="bg-white rounded-2xl shadow-sm border border-slate-200 p-6 mb-6">
    <div class="flex flex-col md:flex-row md:items-center md:justify-between gap-4">
      <div>
        <div class="d-flex align-items-center gap-2">
          <h1 class="h4 mb-0">#<?= (int)$ticket['id'] ?></h1>
          <span class="badge <?= 
            $ticket['status'] === 'open' ? 'bg-primary' : 
            ($ticket['status'] === 'in_progress' ? 'bg-warning text-dark' : 
            ($ticket['status'] === 'resolved' ? 'bg-success' : 'bg-secondary'))
          ?> text-uppercase"><?= str_replace('_', ' ', $ticket['status'] ?? 'open') ?></span>
        </div>
        <div class="mt-2 text-slate-600 text-sm">
          <span class="font-medium"><?= htmlspecialchars((string)($ticket['user_email'] ?? 'User #'.$ticket['user_id'])) ?></span>
          <span class="mx-2 text-slate-300">•</span>
          <span class="text-slate-500"><?= $fmt($ticket['created_at'] ?? '') ?></span>
        </div>
      </div>
      <div class="flex flex-wrap items-center gap-2">
        <form method="post" action="/admin/support/status" class="d-flex align-items-center gap-2">
          <input type="hidden" name="csrf_token" value="<?= htmlspecialchars($csrf) ?>">
          <input type="hidden" name="ticket_id" value="<?= (int)$ticket['id'] ?>">
          <div>
            <select name="status" class="form-select form-select-sm">
              <option value="open" <?= $ticket['status']==='open'?'selected':''; ?>>Open</option>
              <option value="in_progress" <?= $ticket['status']==='in_progress'?'selected':''; ?>>In Progress</option>
              <option value="resolved" <?= $ticket['status']==='resolved'?'selected':''; ?>>Resolved</option>
              <option value="closed" <?= $ticket['status']==='closed'?'selected':''; ?>>Closed</option>
            </select>
          </div>
          <button class="btn btn-primary btn-sm">
            Update
          </button>
        </form>
        <div class="flex items-center gap-2">
          <button type="button" onclick="document.querySelector('textarea[name=\'message\']').focus()" class="btn btn-outline-secondary btn-sm">
            <div class="flex items-center gap-2">
              <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 19l9 2-9-18-9 18 9-2zm0 0v-8" />
              </svg>
              <span>Reply</span>
            </div>
          </button>
          <a href="/admin/support" class="btn btn-outline-secondary btn-sm">
            Back to List
          </a>
        </div>
      </div>
    </div>
  </div>

  <!-- Main Content -->
  <div class="row g-4">
    <div class="col-12 col-lg-8">
      <!-- Ticket Content -->
      <div class="card mb-4">
        <div class="card-body border-bottom">
          <h2 class="text-xl font-semibold text-slate-800 mb-2"><?= htmlspecialchars((string)$ticket['subject']) ?></h2>
          <div class="flex flex-wrap gap-x-6 gap-y-2 text-sm text-slate-600">
            <div class="flex items-center">
              <span class="text-slate-400 mr-2">
                <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                  <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 11H5m14 0a2 2 0 012 2v6a2 2 0 01-2 2H5a2 2 0 01-2-2v-6a2 2 0 012-2m14 0V9a2 2 0 00-2-2M5 11V9a2 2 0 012-2m0 0V5a2 2 0 012-2h6a2 2 0 012 2v2M7 7h10" />
                </svg>
              </span>
              <span class="capitalize"><?= htmlspecialchars((string)$ticket['category']) ?></span>
            </div>
            <div class="flex items-center">
              <span class="text-slate-400 mr-2">
                <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                  <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8v4l3 3m6-3a9 9 0 11-18 0 9 9 0 0118 0z" />
                </svg>
              </span>
              <span>Created: <?= $fmt($ticket['created_at'] ?? '') ?></span>
            </div>
            <div class="flex items-center">
              <span class="text-slate-400 mr-2">
                <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                  <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 16h-1v-4h-1m1-4h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z" />
                </svg>
              </span>
              <span>Priority: <span class="font-medium capitalize <?= 
                $ticket['priority'] === 'high' ? 'text-red-600' : 
                ($ticket['priority'] === 'medium' ? 'text-amber-600' : 'text-slate-600')
              ?>"><?= htmlspecialchars((string)$ticket['priority']) ?></span></span>
            </div>
          </div>
        </div>
        
        <div class="card-body bg-light border-bottom">
          <div class="prose max-w-none text-slate-700">
            <?= nl2br(htmlspecialchars((string)$ticket['message'])) ?>
          </div>
          
          <?php if(!empty($ticket['attachments'])): ?>
          <div class="mt-4 pt-4 border-t border-slate-200">
            <h4 class="text-sm font-medium text-slate-600 mb-2">Attachments</h4>
            <div class="flex flex-wrap gap-2">
              <?php foreach(explode(',', $ticket['attachments']) as $attachment): ?>
                <a href="/uploads/<?= htmlspecialchars($attachment) ?>" target="_blank" class="inline-flex items-center px-3 py-1.5 bg-white border border-slate-200 rounded-lg text-sm text-blue-600 hover:bg-blue-50">
                  <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M7 21h10a2 2 0 002-2V9.414a1 1 0 00-.293-.707l-5.414-5.414A1 1 0 0012.586 3H7a2 2 0 00-2 2v14a2 2 0 002 2z" />
                  </svg>
                  <?= htmlspecialchars(basename($attachment)) ?>
                </a>
              <?php endforeach; ?>
            </div>
          </div>
          <?php endif; ?>
        </div>

        <!-- Conversation Thread -->
        <div class="">
          <div id="chatScrollAdmin" class="card-body" style="max-height:520px; overflow-y:auto;">
            <h3 class="text-lg font-medium text-slate-900 mb-4">Conversation</h3>
            
            <?php if (empty($replies)): ?>
              <div class="text-center py-8">
                <svg class="mx-auto h-12 w-12 text-slate-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                  <path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" d="M8 10h.01M12 10h.01M16 10h.01M9 16H5a2 2 0 01-2-2V6a2 2 0 012-2h14a2 2 0 012 2v8a2 2 0 01-2 2h-5l-5 5v-5z" />
                </svg>
                <h4 class="mt-2 text-sm font-medium text-slate-900">No replies yet</h4>
                <p class="mt-1 text-sm text-slate-500">Be the first to reply to this ticket.</p>
              </div>
            <?php else: ?>
              <div class="space-y-6">
                <?php 
                $previousDate = null;
                foreach ($replies as $index => $r): 
                  $role = strtolower((string)($r['role'] ?? 'user'));
                  $isAdmin = $role === 'admin';
                  $currentDate = date('Y-m-d', strtotime($r['created_at']));
                  $showDate = $currentDate !== $previousDate;
                  $previousDate = $currentDate;
                ?>
                  <?php if ($showDate): ?>
                    <div class="relative my-6">
                      <div class="absolute inset-0 flex items-center" aria-hidden="true">
                        <div class="w-full border-t border-slate-200"></div>
                      </div>
                      <div class="relative flex justify-center">
                        <span class="px-3 bg-white text-sm text-slate-500">
                          <?= date('F j, Y', strtotime($r['created_at'])) ?>
                        </span>
                      </div>
                    </div>
                  <?php endif; ?>
                  
                  <div class="flex gap-3 group" id="reply-<?= $index + 1 ?>">
                    <div class="flex-shrink-0">
                      <div class="relative">
                        <div class="h-10 w-10 rounded-full bg-slate-200 flex items-center justify-center">
                          <span class="text-slate-600 font-medium">
                            <?= strtoupper(substr($role, 0, 1)) ?>
                          </span>
                        </div>
                        <?php if ($isAdmin): ?>
                          <span class="absolute -bottom-1 -right-1 bg-blue-500 rounded-full p-0.5">
                            <svg class="h-3 w-3 text-white" fill="currentColor" viewBox="0 0 20 20">
                              <path fill-rule="evenodd" d="M16.707 5.293a1 1 0 010 1.414l-8 8a1 1 0 01-1.414 0l-4-4a1 1 0 011.414-1.414L8 12.586l7.293-7.293a1 1 0 011.414 0z" clip-rule="evenodd" />
                            </svg>
                          </span>
                        <?php endif; ?>
                      </div>
                    </div>
                    <div class="flex-1 min-w-0">
                      <div class="flex items-center gap-2 mb-1">
                        <span class="text-sm font-medium text-slate-900">
                          <?= ucfirst($role) ?>
                          <?php if ($isAdmin): ?>
                            <span class="ml-1 inline-flex items-center px-2 py-0.5 rounded text-xs font-medium bg-blue-100 text-blue-800">
                              Admin
                            </span>
                          <?php endif; ?>
                        </span>
                        <span class="text-xs text-slate-500">
                          <?= $fmt($r['created_at'] ?? '') ?>
                        </span>
                        <a href="#reply-<?= $index + 1 ?>" class="ml-auto opacity-0 group-hover:opacity-100 transition-opacity text-slate-400 hover:text-slate-600">
                          <svg class="h-4 w-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13.828 10.172a4 4 0 00-5.656 0l-4 4a4 4 0 105.656 5.656l1.102-1.101m-.758-4.899a4 4 0 005.656 0l4-4a4 4 0 00-5.656-5.656l-1.1 1.1" />
                          </svg>
                        </a>
                      </div>
                      <div class="text-sm text-slate-700 bg-white p-4 rounded-lg border border-slate-200 shadow-sm">
                        <?= nl2br(htmlspecialchars((string)$r['message'])) ?>
                      </div>
                    </div>
                  </div>
                <?php endforeach; ?>
              </div>
            <?php endif; ?>
          </div>
          
          <!-- Reply Form -->
          <div class="card-body bg-light border-top">
            <form method="post" action="/admin/support/reply" class="space-y-3" id="adminReplyForm">
              <input type="hidden" name="csrf_token" value="<?= htmlspecialchars($csrf) ?>">
              <input type="hidden" name="ticket_id" value="<?= (int)$ticket['id'] ?>">
              
              <div>
                <label for="message" class="block text-sm font-medium text-slate-700 mb-1">Add a reply</label>
                <div class="mt-1">
                  <textarea 
                    id="message" 
                    name="message" 
                    rows="2" 
                    required 
                    class="form-control"
                    style="resize:none; min-height:44px; max-height:160px;"
                    placeholder="Type your response here... (Ctrl+Enter to send)"
                  ></textarea>
                </div>
                <p class="mt-2 text-sm text-slate-500">
                  Your response will be sent to the ticket creator.
                </p>
              </div>
              
              <div class="d-flex align-items-center justify-content-end gap-2 pt-2">
                <button type="button" class="btn btn-outline-secondary btn-sm">
                  Save as Draft
                </button>
                <button type="submit" class="btn btn-primary btn-sm d-inline-flex align-items-center">
                  <svg class="me-2" width="16" height="16" fill="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 19l9 2-9-18-9 18 9-2zm0 0v-8" />
                  </svg>
                  Send Reply
                </button>
              </div>
            </form>
          </div>
        </div>
      </div>
    </div>

    <!-- Sidebar -->
    <div class="col-12 col-lg-4">
      <div class="d-flex flex-column gap-3">
        <!-- Ticket Details -->
        <div class="card">
          <div class="card-header"><h3 class="h6 mb-0">Ticket Details</h3></div>
          <div class="card-body">
            <div>
              <dt class="text-xs font-medium text-slate-500">Status</dt>
              <dd class="mt-1 text-sm">
                <span class="badge <?= 
                  $ticket['status'] === 'open' ? 'bg-primary' : 
                  ($ticket['status'] === 'in_progress' ? 'bg-warning text-dark' : 
                  ($ticket['status'] === 'resolved' ? 'bg-success' : 'bg-secondary'))
                ?> text-uppercase">
                  <?= str_replace('_', ' ', $ticket['status'] ?? 'open') ?>
                </span>
              </dd>
            </div>
            <div>
              <dt class="text-xs font-medium text-slate-500">Priority</dt>
              <dd class="mt-1 text-sm text-slate-900 capitalize">
                <span class="badge <?= $ticket['priority']==='high' ? 'bg-danger' : ($ticket['priority']==='medium' ? 'bg-warning text-dark' : 'bg-secondary') ?> text-uppercase">
                  <?= htmlspecialchars((string)$ticket['priority']) ?>
                </span>
              </dd>
            </div>
            <div>
              <dt class="text-xs font-medium text-slate-500">Category</dt>
              <dd class="mt-1 text-sm text-slate-900 capitalize"><?= htmlspecialchars((string)$ticket['category']) ?></dd>
            </div>
            <div>
              <dt class="text-xs font-medium text-slate-500">Created</dt>
              <dd class="mt-1 text-sm text-slate-900"><?= $fmt($ticket['created_at'] ?? '') ?></dd>
            </div>
            <div>
              <dt class="text-xs font-medium text-slate-500">Last Updated</dt>
              <dd class="mt-1 text-sm text-slate-900"><?= $fmt($ticket['updated_at'] ?? '') ?></dd>
            </div>
            <?php if($ticket['last_replied_at']): ?>
            <div>
              <dt class="text-xs font-medium text-slate-500">Last Reply</dt>
              <dd class="mt-1 text-sm text-slate-900"><?= $fmt($ticket['last_replied_at']) ?></dd>
            </div>
            <?php endif; ?>
          </div>
        </div>

        <!-- Quick Actions -->
        <div class="card">
          <div class="card-header"><h3 class="h6 mb-0">Quick Actions</h3></div>
          <div class="card-body">
            <form method="post" action="/admin/support/status" class="d-flex flex-column gap-2">
              <input type="hidden" name="csrf_token" value="<?= htmlspecialchars($csrf) ?>">
              <input type="hidden" name="ticket_id" value="<?= (int)$ticket['id'] ?>">
              
              <button type="submit" name="status" value="in_progress" class="btn <?= $ticket['status'] === 'in_progress' ? 'btn-primary' : 'btn-outline-secondary' ?> btn-sm w-100">
                Mark as In Progress
              </button>
              
              <button type="submit" name="status" value="resolved" class="btn <?= $ticket['status'] === 'resolved' ? 'btn-success' : 'btn-outline-secondary' ?> btn-sm w-100">
                Mark as Resolved
              </button>
              
              <button type="submit" name="status" value="closed" class="btn <?= $ticket['status'] === 'closed' ? 'btn-secondary' : 'btn-outline-secondary' ?> btn-sm w-100">
                Close Ticket
              </button>
            </form>
          </div>
        </div>

        <!-- Ticket Properties -->
        <div class="card">
          <div class="card-header"><h3 class="h6 mb-0">Properties</h3></div>
          <div class="card-body">
            <div>
              <dt class="text-xs font-medium text-slate-500">Ticket ID</dt>
              <dd class="mt-0.5 text-sm text-slate-900 font-mono">#<?= str_pad($ticket['id'], 5, '0', STR_PAD_LEFT) ?></dd>
            </div>
            <div>
              <dt class="text-xs font-medium text-slate-500">Agent ID</dt>
              <dd class="mt-0.5 text-sm text-slate-900"><?= (int)$ticket['user_id'] ?></dd>
            </div>
            <div>
              <dt class="text-xs font-medium text-slate-500">Email</dt>
              <dd class="mt-0.5 text-sm text-slate-900 break-all"><?= htmlspecialchars((string)($ticket['user_email'] ?? 'N/A')) ?></dd>
  
  <!-- Sticky Reply Bar (Mobile) -->
  <div class="lg:hidden fixed bottom-0 left-0 right-0 bg-white border-t border-slate-200 p-3 shadow-lg">
    <form method="post" action="/admin/support/reply" class="flex items-end gap-2">
      <input type="hidden" name="csrf_token" value="<?= htmlspecialchars($csrf) ?>">
      <input type="hidden" name="ticket_id" value="<?= (int)$ticket['id'] ?>">
      <div class="flex-1">
        <label for="mobile-message" class="sr-only">Reply</label>
        <input 
          type="text" 
          id="mobile-message" 
          name="message" 
          required 
          class="block w-full rounded-lg border-slate-300 shadow-sm focus:border-blue-500 focus:ring-blue-500 sm:text-sm"
          placeholder="Type a reply..."
        >
      </div>
      <button 
        type="submit" 
        class="btn btn-primary btn-sm rounded-circle"
      >
        <svg class="h-5 w-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
          <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 19l9 2-9-18-9 18 9-2zm0 0v-8" />
        </svg>
      </button>
    </form>
  </div>
  
  <style>
    /* Smooth scrolling for anchor links */
    html {
      scroll-behavior: smooth;
    }
    
    /* Custom scrollbar */
    ::-webkit-scrollbar {
      width: 6px;
      height: 6px;
    }
    
    ::-webkit-scrollbar-track {
      background: #f1f5f9;
    }
    
    ::-webkit-scrollbar-thumb {
      background: #cbd5e1;
      border-radius: 3px;
    }
    
    ::-webkit-scrollbar-thumb:hover {
      background: #94a3b8;
    }
    
    /* Animation for new messages */
    @keyframes highlight {
      0% { background-color: rgba(59, 130, 246, 0.1); }
      100% { background-color: transparent; }
    }
    
    .highlight {
      animation: highlight 2s ease-out;
    }
  </style>
  
  <script>
    // Auto-focus the reply textarea when clicking the reply button
    document.addEventListener('DOMContentLoaded', function() {
      // Scroll chat to bottom on load
      const chatScroll = document.getElementById('chatScrollAdmin');
      if (chatScroll) {
        chatScroll.scrollTop = chatScroll.scrollHeight;
      }

      // Focus reply textarea when clicking reply buttons
      document.querySelectorAll('[data-action="focus-reply"]').forEach(button => {
        button.addEventListener('click', function() {
          const textarea = document.querySelector('textarea[name="message"]');
          if (textarea) {
            textarea.focus();
            // Scroll to the reply form
            textarea.scrollIntoView({ behavior: 'smooth', block: 'center' });
          }
        });
      });
      // Enter to send, Shift+Enter for newline
      const adminTextarea = document.querySelector('#adminReplyForm textarea[name="message"]');
      const adminForm = document.getElementById('adminReplyForm');
      if (adminTextarea) {
        adminTextarea.addEventListener('keydown', function(e){
          if (e.key === 'Enter' && !e.shiftKey) {
            e.preventDefault();
            if (adminForm && this.value.trim() !== '') {
              adminForm.submit();
            }
          }
        });
      }

      // AJAX submit for instant send (no page reload)
      if (adminForm && adminTextarea) {
        adminForm.addEventListener('submit', async function(e){
          e.preventDefault();
          if (adminTextarea.value.trim() === '') return;
          const fd = new FormData(adminForm);
          try{
            const res = await fetch('/admin/support/reply', {method:'POST', body: fd, headers:{'Accept':'application/json','X-Requested-With':'XMLHttpRequest'}});
            if (!res.ok) throw new Error('network');
            const data = await res.json();
            if (data && data.reply && data.reply.id) {
              const chat = document.getElementById('chatScrollAdmin');
              if (chat) {
                chat.insertAdjacentHTML('beforeend', `\n<div class="p-3 border-top bg-light" id="reply-${data.reply.id}">\n  <div class="d-flex align-items-start gap-2">\n    <div class="flex-shrink-0"><span class="badge bg-secondary rounded-circle">&nbsp;</span></div>\n    <div class="flex-grow-1">\n      <div class="d-flex justify-content-between"><div class="fw-semibold small">Support Team</div><div class="text-muted small">just now</div></div>\n      <div class="mt-1 small">${adminTextarea.value.replace(/&/g,'&amp;').replace(/</g,'&lt;').replace(/>/g,'&gt;')}</div>\n    </div>\n  </div>\n</div>`);
                chat.scrollTop = chat.scrollHeight;
              }
              window.adminSinceId = data.reply.id;
              adminTextarea.value='';
              adminTextarea.style.height='';
            }
          }catch(err){ /* optionally toast */ }
        });
      }
      
      // Live polling for new replies
      (function setupLivePollingAdmin(){
        const ticketInput = document.querySelector('#adminReplyForm input[name="ticket_id"]');
        const chat = document.getElementById('chatScrollAdmin');
        if (!ticketInput || !chat) return;
        const ticketId = parseInt(ticketInput.value || '0', 10);
        let sinceId = (function(){
          let maxId = 0;
          chat.querySelectorAll('[id^="reply-"]').forEach(el=>{
            const n = parseInt((el.id||'').replace('reply-',''), 10);
            if (!isNaN(n) && n > maxId) maxId = n;
          });
          return maxId;
        })();
        if (window.adminSinceId && window.adminSinceId > sinceId) sinceId = window.adminSinceId;
        function escapeHtml(s){
          return (s||'').replace(/[&<>"']/g, c=>({"&":"&amp;","<":"&lt;",">":"&gt;","\"":"&quot;","'":"&#39;"}[c]));
        }
        function nearBottom(){
          return (chat.scrollHeight - chat.scrollTop - chat.clientHeight) < 80;
        }
        function renderReply(r){
          const role = (r.role||'').toLowerCase();
          const isAdmin = role === 'admin';
          const isSystem = role === 'system' || role === 'note';
          const bg = isAdmin ? 'bg-light' : (isSystem ? '' : '');
          const who = isAdmin ? 'Support Team' : (isSystem ? 'System' : 'Agent');
          const msg = escapeHtml(r.message||'');
          return `
            <div class="p-3 border-top ${bg}" id="reply-${r.id}">
              <div class="d-flex align-items-start gap-2">
                <div class="flex-shrink-0">
                  <span class="badge bg-secondary rounded-circle">&nbsp;</span>
                </div>
                <div class="flex-grow-1">
                  <div class="d-flex justify-content-between">
                    <div class="fw-semibold small">${who}</div>
                    <div class="text-muted small">just now</div>
                  </div>
                  <div class="mt-1 small">${msg}</div>
                </div>
              </div>
            </div>`;
        }
        async function poll(){
          try{
            const sid = (window.adminSinceId && window.adminSinceId > sinceId) ? window.adminSinceId : sinceId;
            const res = await fetch(`/admin/support/replies?ticket_id=${ticketId}&since_id=${sid}`, {credentials:'same-origin'});
            if (!res.ok) return;
            const data = await res.json();
            if (!data || !data.replies || !data.replies.length) return;
            const stick = nearBottom();
            data.replies.forEach(r=>{
              if (r.id && r.id > sinceId) sinceId = r.id;
              chat.insertAdjacentHTML('beforeend', renderReply(r));
            });
            if (stick) chat.scrollTop = chat.scrollHeight;
          }catch(e){/* ignore */}
        }
        setInterval(poll, 2000);
      })();

      // Highlight new messages in the URL hash
      if (window.location.hash) {
        const target = document.querySelector(window.location.hash);
        if (target) {
          target.classList.add('highlight');
          target.scrollIntoView({ behavior: 'smooth' });
        }
      }
    });
  </script>
<?php endif; ?>
</div>
