<?php
// app/Views/admin/promos/index.php
?>
<div class="container py-4">
  <div class="d-flex align-items-center justify-content-between mb-3">
    <h1 class="h4 mb-0">Promo Codes</h1>
    <div>
      <a href="/admin/promos/create" class="btn btn-sm btn-primary">New Promo</a>
      <a href="/admin" class="btn btn-sm btn-outline-secondary">Dashboard</a>
    </div>
  </div>

  <?php if (!empty($_SESSION['flash'])): ?>
    <div class="alert alert-info py-2"><?php echo htmlspecialchars($_SESSION['flash']); unset($_SESSION['flash']); ?></div>
  <?php endif; ?>
  <?php if (isset($dbName)): ?>
    <div class="text-muted small mb-2">DB: <strong><?php echo htmlspecialchars($dbName); ?></strong> — Rows: <strong><?php echo (int)($rowCount ?? 0); ?></strong></div>
  <?php endif; ?>

  <div class="card shadow-sm">
    <div class="table-responsive">
      <table class="table align-middle mb-0">
        <thead>
          <tr>
            <th>ID</th>
            <th>Code</th>
            <th>Type</th>
            <th>Value</th>
            <th>Valid</th>
            <th>Usage Limit</th>
            <th></th>
          </tr>
        </thead>
        <tbody>
          <?php if (!empty($rows)): foreach ($rows as $r): ?>
            <tr>
              <td>#<?php echo (int)$r['id']; ?></td>
              <td><code><?php echo htmlspecialchars($r['code']); ?></code></td>
              <td class="text-uppercase small"><?php echo htmlspecialchars($r['discount_type']); ?></td>
              <td><?php echo number_format((float)$r['discount_value'], 2); ?></td>
              <td><?php echo htmlspecialchars(($r['valid_from'] ?? '').' - '.($r['valid_to'] ?? '')); ?></td>
              <td><?php echo htmlspecialchars($r['usage_limit'] ?? ''); ?></td>
              <td class="text-end">
                <a class="btn btn-sm btn-outline-primary" href="/admin/promos/edit?id=<?php echo (int)$r['id']; ?>">Edit</a>
                <form method="post" action="/admin/promos/delete" class="d-inline" onsubmit="return confirm('Delete this promo?');">
                  <input type="hidden" name="csrf" value="<?php echo htmlspecialchars(\App\Core\Security::csrfToken()); ?>" />
                  <input type="hidden" name="id" value="<?php echo (int)$r['id']; ?>" />
                  <button class="btn btn-sm btn-outline-danger">Delete</button>
                </form>
              </td>
            </tr>
          <?php endforeach; else: ?>
            <tr>
              <td colspan="7" class="text-center text-muted py-4">No promo codes.</td>
            </tr>
          <?php endif; ?>
        </tbody>
      </table>
    </div>
  </div>
</div>
