<?php
/** @var string $csrf */
/** @var array $vendors */
/** @var int $vendorId */
/** @var array $packages */
/** @var array $variantsByPkg */
/** @var array $pricesByVariant */
/** @var array $timesByPkg */
// Use site layout; set page title for header
if (!isset($title)) { $title = 'Vendor Packages'; }
?>
<style>
  .section-card { border: 1px solid #e9ecef; border-radius: .5rem; padding: 1rem; margin-bottom: 1rem; }
  .chip { display:inline-block; padding:.25rem .5rem; border-radius:1rem; background:#f1f3f5; margin:.125rem; font-size:.85rem }
  .table-sm td, .table-sm th { padding:.35rem .5rem; }
</style>
<div class="container py-3">
  <div class="d-flex justify-content-between align-items-center mb-2">
    <h4 class="mb-0">Vendor Packages</h4>
    <div>
      <a href="/admin/vendors/create" class="btn btn-outline-secondary btn-sm">Back to Vendors</a>
    </div>
  </div>

  <?php if (!empty($_SESSION['flash'])): ?>
    <div class="alert alert-success py-2"><?= htmlspecialchars($_SESSION['flash']) ?></div>
    <?php unset($_SESSION['flash']); endif; ?>
  <?php if (!empty($_SESSION['errors'])): ?>
    <div class="alert alert-danger py-2">
      <?php foreach ((array)$_SESSION['errors'] as $e): ?>
        <div>- <?= htmlspecialchars($e) ?></div>
      <?php endforeach; unset($_SESSION['errors']); ?>
    </div>
  <?php endif; ?>

  <div class="section-card bg-white">
    <form method="get" class="row g-2 align-items-end">
      <div class="col-sm-4 col-md-3">
        <label class="form-label">Country</label>
        <select name="country" class="form-select" onchange="this.form.city.value=''; this.form.vendor_id.value=''; this.form.submit()">
          <option value="">-- All Countries --</option>
          <?php foreach (($countries ?? []) as $c): $cn = is_array($c)? ($c['country'] ?? '') : $c; ?>
            <option value="<?= htmlspecialchars($cn) ?>" <?= isset($selectedCountry) && $selectedCountry===$cn ? 'selected' : '' ?>><?= htmlspecialchars($cn) ?></option>
          <?php endforeach; ?>
        </select>
      </div>
      <div class="col-sm-4 col-md-3">
        <label class="form-label">City</label>
        <select name="city" class="form-select" onchange="this.form.vendor_id.value=''; this.form.submit()">
          <option value="">-- All Cities --</option>
          <?php foreach (($cities ?? []) as $c): $ct = is_array($c)? ($c['city'] ?? '') : $c; ?>
            <option value="<?= htmlspecialchars($ct) ?>" <?= isset($selectedCity) && $selectedCity===$ct ? 'selected' : '' ?>><?= htmlspecialchars($ct) ?></option>
          <?php endforeach; ?>
        </select>
      </div>
      <div class="col-sm-4 col-md-4">
        <label class="form-label">Select Vendor</label>
        <select id="vendorSelect" name="vendor_id" class="form-select" onchange="this.form.submit()">
          <option value="">-- Choose --</option>
          <?php foreach ($vendors as $v): ?>
            <option value="<?= (int)$v['id'] ?>" <?= $vendorId==(int)$v['id']?'selected':'' ?>><?= htmlspecialchars($v['name']) ?></option>
          <?php endforeach; ?>
        </select>
      </div>
      <div class="col-auto"><button class="btn btn-primary">Load</button></div>
    </form>
  </div>

  <?php if ($vendorId > 0): ?>
  <!-- Create/Update Package -->
  <div class="section-card bg-white">
    <h6 class="mb-2">Add New Package</h6>
    <form method="post" action="/admin/vendor-packages/store" class="row g-3" enctype="multipart/form-data">
      <input type="hidden" name="csrf" value="<?= htmlspecialchars($csrf) ?>">
      <input type="hidden" name="vendor_id" value="<?= (int)$vendorId ?>">
      <!-- Row 1: Name | Age Policy | Requires Time | Active -->
      <div class="col-sm-6 col-md-4">
        <label class="form-label">Package Name</label>
        <input id="pkg_name" type="text" name="name" class="form-control" placeholder="e.g., Alcazar Show">
      </div>
      <div class="col-sm-6 col-md-3">
        <label class="form-label">Age Policy</label>
        <select name="age_policy" class="form-select">
          <option value="adult_only" <?= (isset($defaultAgePolicy) && $defaultAgePolicy==='adult_only') ? 'selected' : '' ?>>Adult Only</option>
          <option value="family" <?= (isset($defaultAgePolicy) && $defaultAgePolicy==='family') ? 'selected' : '' ?>>Family (Adult + Child)</option>
        </select>
      </div>
      <div class="col-sm-6 col-md-2 d-flex align-items-end">
        <div class="form-check">
          <input class="form-check-input" type="checkbox" id="requires_time" name="requires_show_time" <?= (!isset($defaultRequiresTime) || (int)$defaultRequiresTime===1) ? 'checked' : '' ?>>
          <label class="form-check-label" for="requires_time">Requires Show Time</label>
        </div>
      </div>
      <div class="col-sm-6 col-md-2 d-flex align-items-end">
        <div class="form-check">
          <input class="form-check-input" type="checkbox" id="pkg_active" name="active" checked>
          <label class="form-check-label" for="pkg_active">Active</label>
        </div>
      </div>

      <!-- Row 2: Show Times | Thumbnail -->
      <div class="col-md-7" id="show_times_wrap">
        <label class="form-label">Show Times (comma separated)</label>
        <input id="show_times_input" type="text" name="show_times" class="form-control" placeholder="e.g., 17:00, 19:00, 21:00" value="<?= isset($defaultShowTimes) ? htmlspecialchars($defaultShowTimes) : '' ?>">
        <small class="text-muted">Format HH:MM, 24-hr. Example: 17:00,19:30</small>
        <div class="mt-1 d-flex flex-wrap gap-1">
          <button type="button" id="btn_use_detected_times" class="btn btn-sm btn-outline-secondary">Use detected</button>
          <button type="button" class="btn btn-sm btn-outline-secondary js-fill-times" data-times="17:00, 19:00, 21:00">17:00,19:00,21:00</button>
          <button type="button" class="btn btn-sm btn-outline-secondary js-fill-times" data-times="18:00, 19:30, 21:00">18:00,19:30,21:00</button>
          <button type="button" class="btn btn-sm btn-outline-secondary" id="btn_clear_times">Clear</button>
        </div>
      </div>
      <div class="col-md-5">
        <label class="form-label">Thumbnail</label>
        <div id="thumb_drop" class="border rounded p-2 text-center bg-light" style="cursor:pointer" tabindex="0" aria-label="Thumbnail dropzone: click or drop image">
          <div id="thumb_preview_wrap" class="mb-2" style="display:none">
            <img id="thumb_preview" src="" alt="Preview" style="max-width:100%; max-height:120px; object-fit:cover;">
          </div>
          <div class="text-muted small">Drag & drop an image here, or click to select</div>
          <input id="thumb_input" type="file" name="thumbnail" accept="image/*" style="display:none">
        </div>
        <small class="text-muted">JPG/PNG/WebP up to 2MB</small>
        <div id="thumb_error" class="text-danger small mt-1" style="display:none"></div>
      </div>
      
      <!-- Row 3: Address | Master Password | Save -->
      <div class="col-md-7">
        <label class="form-label">Address Override (optional)</label>
        <input type="text" name="address_override" class="form-control" placeholder="Leave empty to use vendor address">
      </div>
      <div class="col-md-3">
        <label class="form-label">Master Password</label>
        <input type="password" name="master_password" class="form-control" required>
      </div>
      <div class="col-md-2 d-flex align-items-end">
        <button class="btn btn-success w-100">Save Package</button>
      </div>
    </form>
  </div>

  <!-- Existing Packages section removed intentionally: this page is for adding packages only. -->
  <?php endif; ?>
</div>

<script>
  (function() {
    function tryFillPackageName() {
      var vendorSel = document.getElementById('vendorSelect');
      var pkgName = document.getElementById('pkg_name');
      if (!vendorSel || !pkgName) return;
      var selectedText = vendorSel.options[vendorSel.selectedIndex] ? vendorSel.options[vendorSel.selectedIndex].text.trim() : '';
      if (!selectedText || selectedText === '-- Choose --') return;
      // Fill only if empty
      if (pkgName.value.trim() === '') {
        pkgName.value = selectedText;
      }
    }
    document.addEventListener('DOMContentLoaded', tryFillPackageName);
    // Thumbnail drag & drop
    var dz = document.getElementById('thumb_drop');
    var fi = document.getElementById('thumb_input');
    var pvWrap = document.getElementById('thumb_preview_wrap');
    var pv = document.getElementById('thumb_preview');
    var thumbErr = document.getElementById('thumb_error');
    function showPreview(file){
      if (!file) return;
      // client validations
      if (!file.type.match(/^image\//)) { if (thumbErr){ thumbErr.textContent='Please select an image file.'; thumbErr.style.display=''; } return; }
      if (file.size > 2*1024*1024) { if (thumbErr){ thumbErr.textContent='Image must be under 2MB.'; thumbErr.style.display=''; } return; }
      if (thumbErr) { thumbErr.textContent=''; thumbErr.style.display='none'; }
      var reader = new FileReader();
      reader.onload = function(e){ if (pv){ pv.src = e.target.result; if (pvWrap) pvWrap.style.display=''; } };
      reader.readAsDataURL(file);
    }
    if (dz && fi){
      dz.addEventListener('click', function(){ fi.click(); });
      dz.addEventListener('dragover', function(e){ e.preventDefault(); dz.classList.add('border-primary'); });
      dz.addEventListener('dragleave', function(e){ dz.classList.remove('border-primary'); });
      dz.addEventListener('drop', function(e){ e.preventDefault(); dz.classList.remove('border-primary'); if (e.dataTransfer.files && e.dataTransfer.files[0]) { fi.files = e.dataTransfer.files; showPreview(e.dataTransfer.files[0]); } });
      fi.addEventListener('change', function(){ if (fi.files && fi.files[0]) showPreview(fi.files[0]); });
    }
    // Toggle show times input
    var req = document.getElementById('requires_time');
    var wrap = document.getElementById('show_times_wrap');
    var timesInput = document.getElementById('show_times_input');
    function toggleTimes(){ if (wrap) wrap.style.display = req && req.checked ? '' : 'none'; }
    if (req) {
      req.addEventListener('change', function(){
        toggleTimes();
        if (req.checked && timesInput && timesInput.value.trim()==='' && '<?= isset($defaultShowTimes) ? '1' : '0' ?>'==='1') {
          timesInput.value = '<?= isset($defaultShowTimes) ? htmlspecialchars($defaultShowTimes) : '' ?>';
        }
      });
      toggleTimes();
      // initial fill from server default if available
      if (req.checked && timesInput && timesInput.value.trim()==='' && '<?= isset($defaultShowTimes) ? '1' : '0' ?>'==='1') {
        timesInput.value = '<?= isset($defaultShowTimes) ? htmlspecialchars($defaultShowTimes) : '' ?>';
      }
    }

    // Fallback: scrape existing list show times if input still empty on load
    var detectedTimes = '';
    document.addEventListener('DOMContentLoaded', function() {
      if (!timesInput || timesInput.value.trim() !== '') return;
      // Strategy 1: strict row structure
      var rows = document.querySelectorAll('div.d-flex.justify-content-between.border-bottom.py-1');
      var found = [];
      rows.forEach(function(r){
        var kids = r.querySelectorAll('div');
        if (kids.length >= 2) {
          var label = (kids[0].textContent || '').trim().toLowerCase();
          if (label === 'show times') {
            var txt = (kids[1].textContent || '').trim();
            if (txt) { found.push(txt); }
          }
        }
      });
      // Strategy 2: label with class text-muted then next sibling holds the value
      if (found.length === 0) {
        var labels = document.querySelectorAll('div.text-muted');
        labels.forEach(function(el){
          var label = (el.textContent || '').trim().toLowerCase();
          if (label === 'show times') {
            var sib = el.nextElementSibling;
            if (sib) {
              var txt = (sib.textContent || '').trim();
              if (txt) { found.push(txt); }
            }
          }
        });
      }
      if (found.length > 0) {
        var val = found[0].replace(/\s*,\s*/g, ', ').replace(/\s+/g, ' ').trim();
        detectedTimes = val;
        timesInput.value = val;
      }
    });

    // Quick-fill buttons
    var fillBtns = document.querySelectorAll('.js-fill-times');
    fillBtns.forEach(function(btn){
      btn.addEventListener('click', function(){ if (timesInput){ timesInput.value = (btn.getAttribute('data-times')||'').trim(); } });
    });
    var useDetectedBtn = document.getElementById('btn_use_detected_times');
    if (useDetectedBtn){ useDetectedBtn.addEventListener('click', function(){ if (timesInput && detectedTimes){ timesInput.value = detectedTimes; } }); }
    var clearBtn = document.getElementById('btn_clear_times');
    if (clearBtn){ clearBtn.addEventListener('click', function(){ if (timesInput){ timesInput.value=''; } }); }

    // Validate on submit
    var pkgForm = document.querySelector('form[action="/admin/vendor-packages/store"]');
    if (pkgForm){
      pkgForm.addEventListener('submit', function(e){
        // Require name
        var nameEl = document.getElementById('pkg_name');
        if (nameEl && nameEl.value.trim()==='') { e.preventDefault(); nameEl.focus(); nameEl.classList.add('is-invalid'); return; }
        if (nameEl) nameEl.classList.remove('is-invalid');
        if (req && req.checked) {
          var val = (timesInput && timesInput.value || '').trim();
          if (val !== '') {
            // validate pattern: HH:MM list
            var ok = val.split(',').every(function(t){ t=t.trim(); return /^(?:[01]\d|2[0-3]):[0-5]\d$/.test(t); });
            if (!ok) { e.preventDefault(); timesInput.classList.add('is-invalid'); alert('Please enter times in HH:MM format, comma-separated.'); return; }
          }
          if (timesInput) timesInput.classList.remove('is-invalid');
        }
      });
    }
  })();
</script>
