<?php /** @var array $partner */ /** @var array $entries */ ?>
<div class="container py-3">
  <div class="d-flex justify-content-between align-items-center mb-3">
    <h4 class="mb-0">Channel Partner Wallet</h4>
    <div class="d-flex gap-2">
      <a class="btn btn-sm btn-secondary" href="/admin/management/partners"><i class="bi bi-arrow-left"></i> Back</a>
      <a class="btn btn-sm btn-primary" href="/admin/management/partners/view?id=<?= (int)($partner['id'] ?? 0) ?>"><i class="bi bi-person"></i> Partner</a>
    </div>
  </div>

  <div class="card border-0 shadow-sm mb-3">
    <div class="card-body d-flex align-items-center py-2">
      <i class="bi bi-people me-2 text-primary"></i>
      <div class="fw-semibold text-truncate" title="<?= htmlspecialchars($partner['name'] ?? '') ?>">
        <?= htmlspecialchars($partner['name'] ?? 'Partner') ?>
      </div>
      <div class="ms-auto small">
        Balance:
        <?php $bal = (float)($partner['wallet_balance'] ?? 0); ?>
        <span class="badge bg-<?= $bal > 0 ? 'success' : 'secondary' ?>">THB <?= number_format($bal, 2) ?></span>
      </div>
    </div>
  </div>

  <div class="card shadow-sm border-0">
    <div class="card-header bg-light d-flex align-items-center py-2">
      <div class="d-flex align-items-center">
        <i class="bi bi-clock-history me-2 text-secondary"></i>
        <strong>Wallet History</strong>
      </div>
      <div class="ms-auto d-flex align-items-center gap-2" style="max-width: 540px;">
        <div class="input-group input-group-sm" style="max-width:160px;">
          <span class="input-group-text bg-white">Rows</span>
          <select id="hist-page-size" class="form-select">
            <option value="10" selected>10</option>
            <option value="25">25</option>
            <option value="50">50</option>
            <option value="100">100</option>
          </select>
        </div>
        <div class="input-group input-group-sm">
          <span class="input-group-text bg-white"><i class="bi bi-search"></i></span>
          <input id="hist-search" type="text" class="form-control" placeholder="Search time, flow, from, to, amount, status..." aria-label="Search Wallet History">
        </div>
        <span id="hist-count" class="badge bg-secondary-subtle text-secondary border border-secondary-subtle d-none"></span>
      </div>
    </div>
    <div class="card-body p-0">
      <div class="table-responsive">
        <table class="table table-sm table-hover mb-0 align-middle">
          <thead class="table-light">
            <tr>
              <th class="text-nowrap">Time</th>
              <th>Flow</th>
              <th>From</th>
              <th>To</th>
              <th class="text-end">Amount (THB)</th>
              <th>Status</th>
              <th>Notes</th>
            </tr>
          </thead>
          <tbody id="hist-tbody">
            <?php foreach (($entries ?? []) as $r): ?>
              <tr>
                <td class="text-nowrap"><span class="text-muted small"><?= htmlspecialchars($r['created_at'] ?? '') ?></span></td>
                <td><?= flow_badge($r['flow'] ?? '') ?></td>
                <td><?= htmlspecialchars((string)($r['source'] ?? '')) ?></td>
                <td><?= htmlspecialchars((string)($r['target'] ?? '')) ?></td>
                <td class="text-end fw-semibold"><?= number_format((float)($r['amount'] ?? 0), 2) ?></td>
                <td><?= status_badge($r['status'] ?? '') ?></td>
                <td class="small text-wrap" style="max-width: 360px;">
                  <?php $note = trim((string)($r['note'] ?? '')); ?>
                  <?= $note !== '' ? nl2br(htmlspecialchars($note)) : '<span class="text-muted">—</span>' ?>
                </td>
              </tr>
            <?php endforeach; ?>
          </tbody>
        </table>
      </div>
    </div>
    <div class="card-footer bg-white py-2">
      <div class="d-flex align-items-center justify-content-between">
        <small id="hist-page-info" class="text-muted"></small>
        <nav aria-label="Wallet history pagination">
          <ul id="hist-pagination" class="pagination pagination-sm mb-0"></ul>
        </nav>
      </div>
    </div>
  </div>
</div>

<?php
function flow_badge(string $flow): string {
  if ($flow === 'admin_to_partner') return '<span class="badge bg-warning-subtle text-warning border border-warning-subtle">Admin → Partner</span>';
  if ($flow === 'reverse_admin_to_partner') return '<span class="badge bg-danger-subtle text-danger border border-danger-subtle">Reverse Admin → Partner</span>';
  if ($flow === 'partner_to_agent') return '<span class="badge bg-info-subtle text-info border border-info-subtle">Partner → Agent</span>';
  if ($flow === 'reverse_partner_to_agent') return '<span class="badge bg-danger-subtle text-danger border border-danger-subtle">Reverse Partner → Agent</span>';
  return '<span class="badge bg-secondary-subtle text-secondary border border-secondary-subtle">Seed/Other</span>';
}
function status_badge(string $s): string {
  if ($s === 'approved') return '<span class="badge bg-success">Approved</span>';
  if ($s === 'pending') return '<span class="badge bg-warning text-dark">Pending</span>';
  if ($s === 'rejected') return '<span class="badge bg-danger">Rejected</span>';
  return '<span class="badge bg-secondary">Other</span>';
}
?>

<script>
(function(){
  const tbody = document.getElementById('hist-tbody');
  const search = document.getElementById('hist-search');
  const rowsSel = document.getElementById('hist-page-size');
  const pager = document.getElementById('hist-pagination');
  const count = document.getElementById('hist-count');
  const pageInfo = document.getElementById('hist-page-info');

  let rows = Array.from(tbody.querySelectorAll('tr'));
  let filtered = rows.slice();
  let page = 1;
  let perPage = parseInt(rowsSel.value, 10) || 10;

  function normalize(s){ return (s||'').toString().toLowerCase(); }
  function applyFilter(){
    const q = normalize(search.value);
    filtered = q ? rows.filter(tr => normalize(tr.innerText).includes(q)) : rows.slice();
    page = 1; render();
  }
  function render(){
    rows.forEach(r => r.style.display = 'none');
    const total = filtered.length;
    const pages = Math.max(1, Math.ceil(total / perPage));
    if (page > pages) page = pages;
    const start = (page - 1) * perPage;
    filtered.slice(start, start + perPage).forEach(r => r.style.display = '');
    // pager
    pager.innerHTML = '';
    const prev = document.createElement('li');
    prev.className = 'page-item' + (page<=1?' disabled':'');
    prev.innerHTML = '<a class="page-link" href="#" aria-label="Previous">&laquo;</a>';
    prev.onclick = (e)=>{ e.preventDefault(); if(page>1){ page--; render(); } };
    pager.appendChild(prev);
    const windowSize = 7;
    let startPage = Math.max(1, page - Math.floor(windowSize/2));
    let endPage = Math.min(pages, startPage + windowSize - 1);
    startPage = Math.max(1, endPage - windowSize + 1);
    for (let n = startPage; n <= endPage; n++){
      const li = document.createElement('li');
      li.className = 'page-item' + (n===page?' active':'');
      li.innerHTML = '<a class="page-link" href="#">'+n+'</a>';
      li.onclick = (e)=>{ e.preventDefault(); page=n; render(); };
      pager.appendChild(li);
    }
    const next = document.createElement('li');
    next.className = 'page-item' + (page>=pages?' disabled':'');
    next.innerHTML = '<a class="page-link" href="#" aria-label="Next">&raquo;</a>';
    next.onclick = (e)=>{ e.preventDefault(); if(page<pages){ page++; render(); } };
    pager.appendChild(next);
    // counters
    pageInfo.textContent = total + ' result' + (total===1?'':'s') + (pages>1? (' • page '+page+'/'+pages):'');
    if (total !== rows.length) { count.classList.remove('d-none'); count.textContent = total + '/' + rows.length; } else { count.classList.add('d-none'); }
  }

  search.addEventListener('input', applyFilter);
  rowsSel.addEventListener('change', function(){ perPage = parseInt(this.value,10)||10; render(); });
  // init
  rows = Array.from(tbody.querySelectorAll('tr'));
  applyFilter();
})();
</script>
