<?php /** @var array $partner */ /** @var array $agents */ /** @var string $csrf */ ?>
<div class="container py-3">
  <div class="d-flex justify-content-between align-items-center mb-2">
    <h4 class="mb-0">Agents under: <?= htmlspecialchars($partner['name'] ?? 'Partner') ?></h4>
    <div class="d-flex gap-2">
      <a class="btn btn-outline-secondary btn-sm" href="/admin/management/partners"><i class="bi bi-arrow-left"></i> Back to Partners</a>
      <a class="btn btn-outline-primary btn-sm" href="/admin/management/partners/view?id=<?= (int)$partner['id'] ?>"><i class="bi bi-eye"></i> View Partner</a>
      <a class="btn btn-outline-success btn-sm" href="/admin/management/partners/wallet?id=<?= (int)$partner['id'] ?>"><i class="bi bi-wallet2"></i> Wallet (<?= number_format((float)($partner['wallet_balance'] ?? 0), 2) ?>)</a>
    </div>
  </div>

  <div class="small text-muted mb-3">
    Partner ID: <?= (int)$partner['id'] ?> • Email: <?= htmlspecialchars($partner['contact_email'] ?? '-') ?> • Status: <span class="badge bg-<?= ($partner['status'] === 'Active' ? 'success':'secondary') ?>"><?= htmlspecialchars($partner['status'] ?? '') ?></span>
  </div>

  <div class="d-flex flex-wrap gap-2 align-items-center mb-2">
    <div class="input-group input-group-sm" style="max-width:360px;">
      <span class="input-group-text"><i class="bi bi-search"></i></span>
      <input type="text" id="agentSearch" class="form-control" placeholder="Search name or email">
    </div>
    <div class="ms-auto d-flex gap-2 align-items-center">
      <label class="small text-muted">Rows:</label>
      <select id="agentRows" class="form-select form-select-sm" style="width:80px;">
        <option>10</option>
        <option selected>25</option>
        <option>50</option>
        <option>100</option>
      </select>
      <button id="agentExportCsv" class="btn btn-outline-secondary btn-sm"><i class="bi bi-download me-1"></i>Export CSV</button>
    </div>
  </div>

  <?php if (empty($agents)): ?>
    <div class="alert alert-info">No agents found for this partner.</div>
  <?php endif; ?>

  <div class="table-responsive">
    <table class="table table-striped table-hover align-middle" id="agentsTable">
      <thead>
        <tr>
          <th>#</th>
          <th>Name</th>
          <th>Email</th>
          <th>Status</th>
          <th class="text-end">Wallet</th>
          <th class="text-end">Actions</th>
        </tr>
      </thead>
      <tbody>
        <?php $i=1; foreach ($agents as $a): ?>
          <tr>
            <td><?= $i++ ?></td>
            <td><?= htmlspecialchars($a['name'] ?? '') ?></td>
            <td><?= htmlspecialchars($a['email'] ?? '') ?></td>
            <td><span class="badge bg-<?= ($a['status'] === 'Active' ? 'success':'secondary') ?>"><?= htmlspecialchars($a['status'] ?? '') ?></span></td>
            <td class="text-end"><span class="badge bg-<?= ((float)($a['wallet_balance'] ?? 0))>0? 'success':'secondary' ?>"><?php echo number_format((float)($a['wallet_balance'] ?? 0),2); ?></span></td>
            <td class="text-end">
              <a class="btn btn-outline-secondary btn-sm" href="/admin/management/agents/view?id=<?= (int)$a['id'] ?>"><i class="bi bi-eye"></i> View</a>
            </td>
          </tr>
        <?php endforeach; ?>
      </tbody>
    </table>
  </div>

  <div class="d-flex justify-content-between align-items-center mt-2">
    <div class="small text-muted" id="agentCount"></div>
    <nav>
      <ul class="pagination pagination-sm mb-0" id="agentPager"></ul>
    </nav>
  </div>
</div>

<script>
(function(){
  const table = document.getElementById('agentsTable');
  const tbody = table.querySelector('tbody');
  const rows = Array.from(tbody.querySelectorAll('tr'));
  const search = document.getElementById('agentSearch');
  const rowsSel = document.getElementById('agentRows');
  const pager = document.getElementById('agentPager');
  const count = document.getElementById('agentCount');
  const exportBtn = document.getElementById('agentExportCsv');

  let filtered = rows.slice();
  let page = 1;
  let perPage = parseInt(rowsSel.value, 10) || 25;

  function normalize(s){ return (s||'').toString().toLowerCase(); }
  function applyFilter(){
    const q = normalize(search.value);
    filtered = q ? rows.filter(tr => normalize(tr.innerText).includes(q)) : rows.slice();
    page = 1; render();
  }
  function render(){
    rows.forEach(r => r.style.display = 'none');
    const total = filtered.length;
    const pages = Math.max(1, Math.ceil(total / perPage));
    if (page > pages) page = pages;
    const start = (page - 1) * perPage;
    filtered.slice(start, start + perPage).forEach(r => r.style.display = '');
    // pager
    pager.innerHTML = '';
    const prev = document.createElement('li');
    prev.className = 'page-item' + (page<=1?' disabled':'');
    prev.innerHTML = '<a class="page-link" href="#" aria-label="Previous">&laquo;</a>';
    prev.onclick = (e)=>{ e.preventDefault(); if(page>1){ page--; render(); } };
    pager.appendChild(prev);
    const windowSize = 7;
    let startPage = Math.max(1, page - Math.floor(windowSize/2));
    let endPage = Math.min(pages, startPage + windowSize - 1);
    startPage = Math.max(1, endPage - windowSize + 1);
    for (let n = startPage; n <= endPage; n++){
      const li = document.createElement('li');
      li.className = 'page-item' + (n===page?' active':'');
      li.innerHTML = '<a class="page-link" href="#">'+n+'</a>';
      li.onclick = (e)=>{ e.preventDefault(); page=n; render(); };
      pager.appendChild(li);
    }
    const next = document.createElement('li');
    next.className = 'page-item' + (page>=pages?' disabled':'');
    next.innerHTML = '<a class="page-link" href="#" aria-label="Next">&raquo;</a>';
    next.onclick = (e)=>{ e.preventDefault(); if(page<pages){ page++; render(); } };
    pager.appendChild(next);
    count.textContent = total + ' result' + (total===1?'':'s') + (pages>1? (' • page '+page+'/'+pages):'');
  }
  function exportCsv(){
    const headers = Array.from(table.querySelectorAll('thead th')).map(th => th.textContent.trim());
    const visibleRows = filtered.map(tr => Array.from(tr.children).map(td => '"' + (td.innerText||'').replaceAll('"','""') + '"'));
    const csv = [headers.join(','), ...visibleRows.map(cols => cols.join(','))].join('\n');
    const blob = new Blob([csv], {type: 'text/csv;charset=utf-8;'});
    const url = URL.createObjectURL(blob);
    const a = document.createElement('a');
    a.href = url; a.download = 'partner_agents.csv'; a.click();
    URL.revokeObjectURL(url);
  }

  search.addEventListener('input', applyFilter);
  rowsSel.addEventListener('change', function(){ perPage = parseInt(this.value,10)||25; render(); });
  exportBtn.addEventListener('click', function(e){ e.preventDefault(); exportCsv(); });
  applyFilter();
})();
</script>
