<?php
// app/Views/admin/management_customers_create.php
?>
<div class="container py-2">
  <h2 class="h5 mb-3"><i class="bi bi-person me-2"></i>Add Customer (B2C)</h2>
  <?php if (!empty($_SESSION['flash'])): ?>
    <div class="alert alert-warning py-2 mb-3"><?= htmlspecialchars($_SESSION['flash']); unset($_SESSION['flash']); ?></div>
  <?php endif; ?>
  <form method="post" action="/users/store">
    <input type="hidden" name="csrf" value="<?= htmlspecialchars($csrf ?? '') ?>">
    <input type="hidden" name="role" value="Customer">
    <input type="hidden" name="status" value="Active">
    <div class="row g-3">
      <div class="col-md-4">
        <label class="form-label">Full Name</label>
        <input type="text" name="name" class="form-control" value="<?= htmlspecialchars($_SESSION['old']['name'] ?? '') ?>" required>
      </div>
      <div class="col-md-4">
        <label class="form-label">Email</label>
        <input type="email" name="email" class="form-control" value="<?= htmlspecialchars($_SESSION['old']['email'] ?? '') ?>" required>
      </div>
      <div class="col-md-4">
        <label class="form-label">Password</label>
        <input type="password" name="password" class="form-control" required>
      </div>
    </div>
    <div class="mt-3 d-flex gap-2">
      <button class="btn btn-primary" type="submit">Create Customer</button>
      <a class="btn btn-outline-secondary" href="/users">Users List</a>
    </div>
  </form>
  <?php unset($_SESSION['old']); ?>
</div>
