<?php /** @var array $agents */ ?>
<div class="container py-3">
  <style>
    .ag-table-wrap { border: 1px solid #e9ecef; border-radius: 8px; overflow-x: auto; overflow-y: visible; background: #fff; }
    .ag-table thead th { position: sticky; top: 0; background: #f8f9fa; z-index: 1; box-shadow: inset 0 -1px 0 #e9ecef; }
    .ag-toolbar { gap: .5rem; flex-wrap: wrap; background:#fff; border:1px solid #e9ecef; border-radius:10px; padding:.5rem .75rem; box-shadow: 0 1px 2px rgba(16,24,40,.04); }
    /* Professional button styling for actions (aligned with partners) */
    .ag-action-btn.btn {
      --agb-radius: 10px;
      border-radius: var(--agb-radius);
      border-color: #D0D5DD;
      color: #334155; /* slate-700 */
      background-color: #fff;
      padding: .38rem .7rem;
      line-height: 1.25;
      transition: all .15s ease-in-out;
      box-shadow: 0 1px 1px rgba(16,24,40,.04);
    }
    .ag-action-btn.btn:hover { background-color: #F8FAFC; border-color:#CBD5E1; box-shadow: 0 2px 4px rgba(16,24,40,.08); }
    .ag-action-btn.btn:active { background-color: #EEF2F7; border-color:#C7CED6; box-shadow: inset 0 1px 2px rgba(16,24,40,.12); }
    .ag-card .ag-action-btn i, .ag-actions-td .ag-action-btn i { opacity:.9; }
    /* Icon-only links (no pill, no border) */
    .ag-action-btn .ag-label { display:none; }
    .ag-action-btn.btn {
      background: transparent !important;
      border-color: transparent !important;
      box-shadow: none !important;
      padding: .125rem .25rem;
      border-radius: 6px;
      width: auto; height: auto;
      display: inline-flex; align-items: center; justify-content: center;
      color: #111827; /* text-slate-900 */
    }
    .ag-action-btn i { margin-right:0; font-size:1.05rem; color:#111827 !important; }
    .ag-action-btn.btn:hover i { color:#0d6efd !important; }
    .ag-action-btn.btn:focus { outline: 0; box-shadow: 0 0 0 .15rem rgba(13,110,253,.15) !important; }
    /* Per-action accents */
    .ag-btn-view { color:#0369A1; border-color:#93C5FD; }
    .ag-btn-view:hover { background:#EFF6FF; border-color:#60A5FA; }
    .ag-btn-edit { color:#0F766E; border-color:#99F6E4; }
    .ag-btn-edit:hover { background:#ECFEFF; border-color:#5EEAD4; }
    .ag-btn-settings { color:#6D28D9; border-color:#C4B5FD; }
    .ag-btn-settings:hover { background:#F5F3FF; border-color:#A78BFA; }
    .ag-btn-password { color:#B45309; border-color:#FCD34D; }
    .ag-btn-password:hover { background:#FFFBEB; border-color:#FBBF24; }
    /* Subtle table row hover and active focus */
    .ag-table tbody tr { transition: background-color .12s ease-in-out; }
    .ag-table tbody tr:hover { background-color:#FBFCFE; box-shadow: inset 3px 0 0 #D6E4FF; }
    /* Badges refinement */
    .badge.bg-success, .badge.bg-secondary { border-radius: 999px; padding:.35em .6em; font-weight:600; letter-spacing:.2px; }
    .badge.bg-secondary { background-color:#E5E7EB !important; color:#374151; }
    /* Toolbar inputs */
    .ag-toolbar .input-group-text { background:#F8FAFC; border-color:#E5E7EB; }
    .ag-toolbar .form-select, .ag-toolbar .form-control { border-color:#E5E7EB; }
    /* Export buttons */
    #agentExportCsv.btn, #agentExportXls.btn { border-color:#D0D5DD; color:#334155; background:#fff; box-shadow: 0 1px 1px rgba(16,24,40,.04); }
    #agentExportCsv.btn:hover, #agentExportXls.btn:hover { background:#F8FAFC; border-color:#CBD5E1; }
    /* Pagination polish */
    .pagination .page-link { color:#334155; border-color:#E5E7EB; }
    .pagination .page-item.active .page-link { background:#2E90FA; border-color:#2E90FA; color:#fff; box-shadow: 0 1px 2px rgba(16,24,40,.12); }
    .pagination .page-item.disabled .page-link { color:#94A3B8; }
    /* Switches larger hit area */
    .form-check-input.ag-status-switch { width: 2.5em; height: 1.25em; }
    /* Mobile cards */
    .ag-card { border:1px solid #e9ecef; border-radius:10px; background:#fff; padding:12px; box-shadow: 0 1px 2px rgba(16,24,40,.05); position:relative; }
    .ag-card:before { content:''; position:absolute; left:0; top:0; bottom:0; width:4px; border-radius:10px 0 0 10px; background:linear-gradient(180deg,#D6E4FF,#EDE9FE); }
    .ag-card + .ag-card { margin-top:10px; }
    .ag-card .ag-card-head { display:flex; align-items:center; justify-content:space-between; gap:8px; }
    .ag-card .ag-card-sub { color:#6c757d; font-size:.875rem; margin-top:4px; }
    .ag-card .ag-card-meta { display:flex; flex-wrap:wrap; gap:6px 10px; margin-top:8px; }
    .ag-card .ag-card-meta .item { color:#6c757d; font-size:.85rem; }
    .ag-card .ag-actions { display:flex; align-items:center; justify-content:space-between; gap:8px; margin-top:10px; }
    /* Settings modal buttons */
    .js-gen-api.btn, .js-rotate-api.btn { border-radius:10px; }
    .js-rotate-api.btn.btn-outline-warning { color:#B54708; border-color:#FEC84B; }
    .js-rotate-api.btn.btn-outline-warning:hover { background:#FFF7E6; border-color:#FDB022; }
    /* xs mobile tweaks */
    @media (max-width: 576px){
      .ag-toolbar { row-gap:.5rem; padding:.5rem; }
      .ag-toolbar .input-group { width: 100%; }
      .ag-toolbar .ms-auto { width: 100%; display:flex; flex-wrap: wrap; gap:.5rem; justify-content: space-between; }
      #agentStatus, #agentRows { flex:1 1 calc(50% - .5rem); min-width: 140px; }
      #agentExportCsv, #agentExportXls { flex: 1 1 calc(50% - .5rem); min-width: 140px; }
      .pagination .page-link { min-width: 36px; height: 36px; display:flex; align-items:center; justify-content:center; }
      .btn.btn-sm { padding: .4rem .7rem; }
    }
  </style>
  <div class="d-flex justify-content-between align-items-center mb-3">
    <h4 class="mb-0">Agent List</h4>
    <a class="btn btn-sm btn-primary" href="/admin/management/agents/create" title="Add Agent" data-bs-toggle="tooltip" aria-label="Add Agent">
      <i class="bi bi-person-plus"></i>
    </a>
  </div>

  <div class="d-flex ag-toolbar align-items-center mb-2">
    <div class="input-group input-group-sm" style="max-width:320px;">
      <span class="input-group-text"><i class="bi bi-search"></i></span>
      <input type="text" id="agentSearch" class="form-control" placeholder="Search name, email, company, phone, city, country">
    </div>
    <div class="ms-auto d-flex gap-2 align-items-center">
      <label class="small text-muted">Status:</label>
      <select id="agentStatus" class="form-select form-select-sm" style="width:130px;">
        <option value="">All</option>
        <option value="Active">Active</option>
        <option value="Inactive">Inactive</option>
      </select>
      <label class="small text-muted">Rows:</label>
      <select id="agentRows" class="form-select form-select-sm" style="width:80px;">
        <option>10</option>
        <option selected>25</option>
        <option>50</option>
        <option>100</option>
      </select>
      <button id="agentExportCsv" class="btn btn-outline-secondary btn-sm" title="Export CSV" data-bs-toggle="tooltip" aria-label="Export CSV">
        <i class="bi bi-download"></i>
      </button>
      <button id="agentExportXls" class="btn btn-outline-secondary btn-sm" title="Export Excel" data-bs-toggle="tooltip" aria-label="Export Excel">
        <i class="bi bi-file-earmark-excel"></i>
      </button>
    </div>
  </div>

  <!-- Mobile Cards (visible on < md) -->
  <div id="agCards" class="d-md-none">
    <?php if (empty($agents)): ?>
      <div class="text-center text-muted py-5">No agents found.</div>
    <?php else: foreach ($agents as $a): ?>
      <?php $hasWallet = isset($a['wallet_balance']); $wb = $hasWallet ? (float)$a['wallet_balance'] : 0; ?>
      <div class="ag-card" data-id="<?= (int)$a['id'] ?>">
        <div class="ag-card-head">
          <div>
            <div class="fw-semibold"><?= htmlspecialchars($a['name'] ?? '') ?></div>
            <div class="ag-card-sub">
              <span class="me-2">ID: <?= (int)$a['id'] ?></span>
              <span class="badge bg-<?= ($a['status'] === 'Active' ? 'success' : 'secondary') ?>"><?= htmlspecialchars($a['status'] ?? '') ?></span>
            </div>
          </div>
          <?php if (!empty($a['has_wallet'])): ?>
            <?php $balance = (float)($a['wallet_balance'] ?? 0); ?>
            <span class="badge bg-<?= $balance > 0 ? 'success' : 'secondary' ?>"><?= number_format($balance, 2) ?></span>
          <?php else: ?>
            <button type="button" class="btn btn-xs btn-outline-primary create-wallet" data-agent-id="<?= (int)$a['id'] ?>" data-agent-name="<?= htmlspecialchars($a['name'] ?? '') ?>">
              <i class="bi bi-wallet2"></i> Create
            </button>
          <?php endif; ?>
        </div>
        <div class="ag-card-meta">
          <div class="item"><i class="bi bi-envelope me-1"></i><?= htmlspecialchars($a['email'] ?? '-') ?></div>
          <div class="item"><i class="bi bi-building me-1"></i><?= htmlspecialchars($a['company'] ?? '-') ?></div>
          <div class="item"><i class="bi bi-telephone me-1"></i><?= htmlspecialchars($a['phone'] ?? '-') ?></div>
          <div class="item"><i class="bi bi-geo-alt me-1"></i><?= htmlspecialchars($a['city'] ?? '-') ?>, <?= htmlspecialchars($a['country'] ?? '-') ?></div>
          <div class="item"><i class="bi bi-people me-1"></i><?= htmlspecialchars($a['partner_name'] ?? '—') ?></div>
        </div>
        <div class="ag-actions">
          <div class="d-flex flex-wrap gap-1">
            <a class="btn btn-outline-secondary btn-sm ag-action-btn ag-btn-view" href="/admin/management/agents/view?id=<?= (int)$a['id'] ?>" title="View"><i class="bi bi-eye-fill me-1"></i><span class="ag-label">View</span></a>
            <a class="btn btn-outline-secondary btn-sm ag-action-btn ag-btn-edit" href="/users/edit?id=<?= (int)$a['id'] ?>" title="Edit"><i class="bi bi-pencil me-1"></i><span class="ag-label">Edit</span></a>
            <button type="button" class="btn btn-outline-secondary btn-sm ag-action-btn ag-btn-settings js-open-settings" data-agent-id="<?= (int)$a['id'] ?>" data-agent-name="<?= htmlspecialchars($a['name'] ?? '') ?>" title="Settings"><i class="bi bi-sliders2 me-1"></i><span class="ag-label">Settings</span></button>
            <button type="button" class="btn btn-outline-secondary btn-sm ag-action-btn ag-btn-password js-open-change-password" data-agent-id="<?= (int)$a['id'] ?>" data-agent-name="<?= htmlspecialchars($a['name'] ?? '') ?>" title="Change Password"><i class="bi bi-key-fill me-1"></i><span class="ag-label">Password</span></button>
          </div>
          <form method="post" action="/admin/management/agents/toggle_status" class="d-inline align-middle ag-switch-form ms-2">
            <input type="hidden" name="csrf" value="<?= htmlspecialchars($csrf ?? '') ?>">
            <input type="hidden" name="id" value="<?= (int)$a['id'] ?>">
            <div class="form-check form-switch m-0" title="Enable/Disable Agent">
              <?php $isActive = ($a['status'] === 'Active'); ?>
              <input class="form-check-input ag-status-switch" type="checkbox" role="switch" <?= $isActive ? 'checked' : '' ?> aria-label="Toggle status">
            </div>
          </form>
          <!-- Hidden reset password form for JS modal submission -->
          <form method="post" action="/admin/management/agents/reset_password" class="d-inline js-hidden-reset-form">
            <input type="hidden" name="csrf" value="<?= htmlspecialchars($csrf ?? '') ?>">
            <input type="hidden" name="id" value="<?= (int)$a['id'] ?>">
            <input type="hidden" name="new_password" value="">
            <input type="hidden" name="master_password" value="">
          </form>
          <!-- Hidden button used by JS to open settings modal with context -->
          <button type="button" class="btn btn-outline-success btn-sm d-none js-agent-settings" data-agent-id="<?= (int)$a['id'] ?>" data-agent-name="<?= htmlspecialchars($a['name'] ?? '') ?>">
            <i class="bi bi-sliders"></i> Settings
          </button>
        </div>
      </div>
    <?php endforeach; endif; ?>
  </div>

  <!-- Desktop table (hidden on < md) -->
  <div class="table-responsive ag-table-wrap d-none d-md-block">
    <table class="table table-striped table-hover align-middle ag-table mb-0">
      <thead>
        <tr>
          <th>ID</th>
          <th>Name</th>
          <th>Email</th>
          <th>Status</th>
          <th>Company</th>
          <th>Phone</th>
          <th>City</th>
          <th>Country</th>
          <th>Commission %</th>
          <th>Wallet</th>
          <th>Partner</th>
          <th>Actions</th>
        </tr>
      </thead>
      <tbody>
        <?php if (empty($agents)): ?>
          <tr><td colspan="12" class="text-center text-muted">No agents found.</td></tr>
        <?php else: foreach ($agents as $a): ?>
          <tr>
            <td><?= (int)$a['id'] ?></td>
            <td><?= htmlspecialchars($a['name'] ?? '') ?></td>
            <td><?= htmlspecialchars($a['email'] ?? '') ?></td>
            <td><span class="badge bg-<?= ($a['status'] === 'Active' ? 'success' : 'secondary') ?>"><?= htmlspecialchars($a['status'] ?? '') ?></span></td>
            <td><?= htmlspecialchars($a['company'] ?? '') ?></td>
            <td><?= htmlspecialchars($a['phone'] ?? '') ?></td>
            <td><?= htmlspecialchars($a['city'] ?? '') ?></td>
            <td><?= htmlspecialchars($a['country'] ?? '') ?></td>
            <td><?= number_format((float)($a['commission_percent'] ?? 0), 2) ?></td>
            <td>
              <?php if (!empty($a['has_wallet'])): ?>
                <?php $balance = (float)($a['wallet_balance'] ?? 0); ?>
                <span class="badge bg-<?= $balance > 0 ? 'success' : 'secondary' ?>"><?= number_format($balance, 2) ?></span>
              <?php else: ?>
                <button type="button" class="btn btn-sm btn-outline-primary create-wallet" data-agent-id="<?= (int)$a['id'] ?>" data-agent-name="<?= htmlspecialchars($a['name'] ?? '') ?>">
                  <i class="bi bi-wallet2"></i> Create Wallet
                </button>
              <?php endif; ?>
            </td>
            <td>
              <?php if (!empty($a['partner_id'])): ?>
                <a href="/admin/management/partners/view?id=<?= (int)$a['partner_id'] ?>" class="text-decoration-none">
                  <?= htmlspecialchars($a['partner_name'] ?? '') ?>
                </a>
              <?php else: ?>
                <span class="text-muted">—</span>
              <?php endif; ?>
            </td>
            <td class="ag-actions-td">
              <div class="d-flex align-items-center justify-content-between flex-wrap gap-2">
                <div class="d-flex flex-wrap gap-1">
                  <a class="btn btn-outline-secondary btn-sm ag-action-btn ag-btn-view" href="/admin/management/agents/view?id=<?= (int)$a['id'] ?>" title="View"><i class="bi bi-eye-fill me-1"></i><span class="ag-label">View</span></a>
                  <a class="btn btn-outline-secondary btn-sm ag-action-btn ag-btn-edit" href="/users/edit?id=<?= (int)$a['id'] ?>" title="Edit"><i class="bi bi-pencil me-1"></i><span class="ag-label">Edit</span></a>
                  <button type="button" class="btn btn-outline-secondary btn-sm ag-action-btn ag-btn-settings js-open-settings" data-agent-id="<?= (int)$a['id'] ?>" data-agent-name="<?= htmlspecialchars($a['name'] ?? '') ?>" title="Settings"><i class="bi bi-sliders2 me-1"></i><span class="ag-label">Settings</span></button>
                  <button type="button" class="btn btn-outline-secondary btn-sm ag-action-btn ag-btn-password js-open-change-password" data-agent-id="<?= (int)$a['id'] ?>" data-agent-name="<?= htmlspecialchars($a['name'] ?? '') ?>" title="Change Password"><i class="bi bi-key-fill me-1"></i><span class="ag-label">Password</span></button>
                </div>
                <form method="post" action="/admin/management/agents/toggle_status" class="d-inline align-middle ag-switch-form">
                  <input type="hidden" name="csrf" value="<?= htmlspecialchars($csrf ?? '') ?>">
                  <input type="hidden" name="id" value="<?= (int)$a['id'] ?>">
                  <div class="form-check form-switch m-0" title="Enable/Disable Agent">
                    <?php $isActive = ($a['status'] === 'Active'); ?>
                    <input class="form-check-input ag-status-switch" type="checkbox" role="switch" <?= $isActive ? 'checked' : '' ?> aria-label="Toggle status">
                  </div>
                </form>
                <!-- Hidden password reset form -->
                <form method="post" action="/admin/management/agents/reset_password" class="d-inline js-hidden-reset-form">
                  <input type="hidden" name="csrf" value="<?= htmlspecialchars($csrf ?? '') ?>">
                  <input type="hidden" name="id" value="<?= (int)$a['id'] ?>">
                  <input type="hidden" name="new_password" value="">
                  <input type="hidden" name="master_password" value="">
                </form>
                <button type="button" class="btn btn-outline-success btn-sm d-none js-agent-settings" data-agent-id="<?= (int)$a['id'] ?>" data-agent-name="<?= htmlspecialchars($a['name'] ?? '') ?>">
                  <i class="bi bi-sliders"></i> Settings
                </button>
              </div>
            </td>
          </tr>
        <?php endforeach; endif; ?>
      </tbody>
    </table>
  </div>
  <div class="d-flex justify-content-between align-items-center mt-2">
    <div class="small text-muted" id="agentCount"></div>
    <nav>
      <ul class="pagination pagination-sm mb-0" id="agentPager"></ul>
    </nav>
  </div>
</div>

<script>
(function(){
  const table = document.querySelector('table');
  const tbody = table.querySelector('tbody');
  const rows = Array.from(tbody.querySelectorAll('tr'));
  const cardsWrap = document.getElementById('agCards');
  const cards = Array.from(cardsWrap ? cardsWrap.querySelectorAll('.ag-card') : []);
  const search = document.getElementById('agentSearch');
  const rowsSel = document.getElementById('agentRows');
  const statusSel = document.getElementById('agentStatus');
  const pager = document.getElementById('agentPager');
  const count = document.getElementById('agentCount');
  const exportBtn = document.getElementById('agentExportCsv');
  const exportXlsBtn = document.getElementById('agentExportXls');
  
  // Handle create wallet button clicks
  async function handleCreateWallet(e) {
    const btn = e.target.closest('.create-wallet');
    if (!btn) return;
    
    const agentId = btn.dataset.agentId;
    const agentName = btn.dataset.agentName || 'this agent';
    
    if (!confirm(`Create wallet for ${agentName}?`)) return;
    
    try {
      // Show loading state
      const originalText = btn.innerHTML;
      btn.disabled = true;
      btn.innerHTML = '<span class="spinner-border spinner-border-sm" role="status" aria-hidden="true"></span> Creating...';
      
      const response = await fetch('/admin/management/agents/create_wallet', {
        method: 'POST',
        headers: {
          'Content-Type': 'application/x-www-form-urlencoded',
          'X-Requested-With': 'XMLHttpRequest'
        },
        body: `agent_id=${agentId}&csrf=<?= $csrf ?? '' ?>`
      });
      
      const result = await response.json();
      
      if (result.success) {
        // Show success message
        const toast = document.createElement('div');
        toast.className = 'position-fixed bottom-0 end-0 m-3 p-3 bg-success text-white rounded shadow';
        toast.style.zIndex = '1090';
        toast.innerHTML = `
          <div class="d-flex align-items-center">
            <i class="bi bi-check-circle-fill me-2"></i>
            <span>Wallet created successfully for ${agentName}</span>
          </div>
        `;
        document.body.appendChild(toast);
        
        // Remove toast after 3 seconds
        setTimeout(() => {
          toast.remove();
          // Reload the page to show updated wallet
          window.location.reload();
        }, 2000);
      } else {
        throw new Error(result.message || 'Failed to create wallet');
      }
    } catch (error) {
      console.error('Error creating wallet:', error);
      alert(`Error: ${error.message || 'Failed to create wallet. Please try again.'}`);
      btn.disabled = false;
      btn.innerHTML = originalText;
    }
  }
  
  // Add event listener for create wallet buttons
  document.addEventListener('click', handleCreateWallet);

  // Build a combined dataset of table rows + corresponding mobile cards
  const data = rows.map(tr => {
    const idCell = tr.querySelector('td:first-child');
    const id = idCell ? parseInt(idCell.textContent.trim(), 10) : NaN;
    const card = cards.find(c => parseInt(c.getAttribute('data-id'), 10) === id);
    return { id, tr, card };
  });

  let filtered = data.slice();
  let page = 1;
  let perPage = parseInt(rowsSel.value, 10) || 25;

  function normalize(s){ return (s||'').toString().toLowerCase(); }
  function rowStatusFromTr(tr){
    const badge = tr.querySelector('td:nth-child(4) .badge');
    return badge ? (badge.textContent || '').trim() : '';
  }
  function rowStatus(item){
    const fromTr = rowStatusFromTr(item.tr);
    if (fromTr) return fromTr;
    const cardBadge = item.card ? item.card.querySelector('.ag-card-sub .badge') : null;
    return cardBadge ? (cardBadge.textContent||'').trim() : '';
  }

  function applyFilter(){
    const q = normalize(search.value);
    const wantStatus = (statusSel && statusSel.value) ? statusSel.value : '';
    filtered = data.filter(item => {
      const trTxt = normalize(item.tr.innerText);
      const cardTxt = item.card ? normalize(item.card.innerText) : '';
      const matchesText = q ? (trTxt.includes(q) || cardTxt.includes(q)) : true;
      const matchesStatus = wantStatus ? (rowStatus(item) === wantStatus) : true;
      return matchesText && matchesStatus;
    });
    page = 1; render();
  }

  function render(){
    rows.forEach(r => r.style.display = 'none');
    cards.forEach(c => c.style.display = 'none');
    const total = filtered.length;
    const pages = Math.max(1, Math.ceil(total / perPage));
    if (page > pages) page = pages;
    const start = (page - 1) * perPage;
    filtered.slice(start, start + perPage).forEach(item => {
      if (item.tr) item.tr.style.display = '';
      if (item.card) item.card.style.display = '';
    });
    // pager
    pager.innerHTML = '';
    const prev = document.createElement('li');
    prev.className = 'page-item' + (page<=1?' disabled':'');
    prev.innerHTML = '<a class="page-link" href="#" aria-label="Previous">&laquo;</a>';
    prev.onclick = (e)=>{ e.preventDefault(); if(page>1){ page--; render(); } };
    pager.appendChild(prev);
    const windowSize = 7;
    let startPage = Math.max(1, page - Math.floor(windowSize/2));
    let endPage = Math.min(pages, startPage + windowSize - 1);
    startPage = Math.max(1, endPage - windowSize + 1);
    for (let n = startPage; n <= endPage; n++){
      const li = document.createElement('li');
      li.className = 'page-item' + (n===page?' active':'');
      li.innerHTML = '<a class="page-link" href="#">'+n+'</a>';
      li.onclick = (e)=>{ e.preventDefault(); page=n; render(); };
      pager.appendChild(li);
    }
    const next = document.createElement('li');
    next.className = 'page-item' + (page>=pages?' disabled':'');
    next.innerHTML = '<a class="page-link" href="#" aria-label="Next">&raquo;</a>';
    next.onclick = (e)=>{ e.preventDefault(); if(page<pages){ page++; render(); } };
    pager.appendChild(next);
    count.textContent = total + ' result' + (total===1?'':'s') + (pages>1? (' • page '+page+'/'+pages):'');
  }

  function exportCsv(){
    const headers = Array.from(table.querySelectorAll('thead th')).map(th => th.textContent.trim());
    const visibleRows = filtered.map(item => Array.from(item.tr.children).map(td => '"' + (td.innerText||'').replaceAll('"','""') + '"'));
    const csv = [headers.join(','), ...visibleRows.map(cols => cols.join(','))].join('\n');
    const blob = new Blob([csv], {type: 'text/csv;charset=utf-8;'});
    const url = URL.createObjectURL(blob);
    const a = document.createElement('a'); a.href = url; a.download = 'agents.csv'; a.click(); URL.revokeObjectURL(url);
  }

  function exportXls(){
    const headersAll = Array.from(table.querySelectorAll('thead th')).map(th => th.textContent.trim());
    const idxActions = headersAll.findIndex(h => h.toLowerCase() === 'actions');
    const headers = headersAll.filter((_,i)=> i !== idxActions);
    const rowsHtml = filtered.map(item => {
      const tds = Array.from(item.tr.children).map(td => (td.innerText||'').trim());
      const cols = tds.filter((_,i)=> i !== idxActions).map(txt => `<td>${escapeHtml(txt)}</td>`).join('');
      return `<tr>${cols}</tr>`;
    }).join('');
    const thead = `<thead><tr>${headers.map(h=>`<th>${escapeHtml(h)}</th>`).join('')}</tr></thead>`;
    const tbody = `<tbody>${rowsHtml}</tbody>`;
    const html = `<!DOCTYPE html><html><head><meta charset="utf-8"><meta http-equiv="X-UA-Compatible" content="IE=edge"><title>Agents</title></head><body><table border="1">${thead}${tbody}</table></body></html>`;
    const blob = new Blob([html], { type: 'application/vnd.ms-excel' });
    const url = URL.createObjectURL(blob);
    const a = document.createElement('a'); a.href = url; a.download = 'agents.xls'; a.click(); URL.revokeObjectURL(url);
  }

  function escapeHtml(s){
    return (s||'').replace(/&/g,'&amp;').replace(/</g,'&lt;').replace(/>/g,'&gt;').replace(/\"/g,'&quot;').replace(/'/g,'&#39;');
  }

  // Switch-style enable/disable: submit on change
  document.addEventListener('change', function(e){
    const sw = e.target.closest('.ag-status-switch');
    if (!sw) return;
    const form = sw.closest('form');
    if (!form) return;
    sw.disabled = true;
    if (typeof form.requestSubmit === 'function') form.requestSubmit(); else form.submit();
    setTimeout(()=>{ sw.disabled = false; }, 1500);
  });

  // events
  search.addEventListener('input', function(){ clearTimeout(window.__agT); window.__agT=setTimeout(applyFilter,150); });
  statusSel.addEventListener('change', applyFilter);
  rowsSel.addEventListener('change', function(){ perPage = parseInt(this.value,10)||25; render(); });
  exportBtn.addEventListener('click', function(e){ e.preventDefault(); exportCsv(); });
  exportXlsBtn.addEventListener('click', function(e){ e.preventDefault(); exportXls(); });
  // initial
  applyFilter();

  // Init tooltips for icon-only buttons
  if (window.bootstrap) {
    var tts = [].slice.call(document.querySelectorAll('[data-bs-toggle="tooltip"]'));
    tts.forEach(function(el){ try { new bootstrap.Tooltip(el); } catch(e){} });
  }

  // ===== Lightweight Password Modal for Agents =====
  let pwOverlay=null, pwModal=null, pwNew=null, pwMaster=null, pwConfirm=null, pwCancel=null, pwDesc=null, targetForm=null;
  function ensurePwModal(){
    if (pwOverlay) return;
    pwOverlay=document.createElement('div'); pwOverlay.style.cssText='position:fixed;inset:0;background:rgba(0,0,0,.45);display:none;z-index:20000;';
    pwModal=document.createElement('div'); pwModal.style.cssText='position:fixed;left:50%;top:50%;transform:translate(-50%,-50%);background:#fff;border-radius:8px;box-shadow:0 10px 30px rgba(0,0,0,.2);width:min(95vw,420px);z-index:20001;display:none;';
    const hdr=document.createElement('div'); hdr.style.cssText='padding:10px 12px;border-bottom:1px solid #eee;font-weight:600;display:flex;justify-content:space-between;align-items:center;'; hdr.innerHTML='<span>Change Agent Password</span>';
    const x=document.createElement('button'); x.type='button'; x.textContent='×'; x.style.cssText='border:0;background:transparent;font-size:20px;line-height:1;cursor:pointer;'; hdr.appendChild(x);
    const body=document.createElement('div'); body.style.cssText='padding:12px;'; body.innerHTML='<div class="mb-2 small text-muted" id="agPwDesc">Enter a new password and master password.</div><div class="mb-3"><label class="form-label">New Password</label><input type="password" class="form-control" id="agPwNew" autocomplete="new-password" placeholder="At least 6 characters"></div><div class="mb-2"><label class="form-label">Master Password</label><input type="password" class="form-control" id="agPwMaster" placeholder="Confirm with Admin Master Password"></div>';
    const ftr=document.createElement('div'); ftr.style.cssText='padding:10px 12px;border-top:1px solid #eee;display:flex;justify-content:flex-end;gap:8px;';
    const cancel=document.createElement('button'); cancel.type='button'; cancel.className='btn btn-outline-secondary btn-sm'; cancel.textContent='Cancel';
    const ok=document.createElement('button'); ok.type='button'; ok.className='btn btn-primary btn-sm'; ok.textContent='Change Password';
    ftr.appendChild(cancel); ftr.appendChild(ok);
    pwModal.appendChild(hdr); pwModal.appendChild(body); pwModal.appendChild(ftr);
    document.body.appendChild(pwOverlay); document.body.appendChild(pwModal);
    function show(){ pwOverlay.style.display='block'; pwModal.style.display='block'; }
    function hide(){ pwOverlay.style.display='none'; pwModal.style.display='none'; }
    pwOverlay.addEventListener('click', hide); x.addEventListener('click', hide); cancel.addEventListener('click', hide);
    pwNew = body.querySelector('#agPwNew'); pwMaster = body.querySelector('#agPwMaster'); pwDesc = body.querySelector('#agPwDesc'); pwConfirm = ok; pwCancel = cancel;
    pwConfirm.addEventListener('click', ()=>{
      if (!targetForm) return;
      const np = (pwNew.value||'').trim(); const mp = (pwMaster.value||'').trim();
      if (np.length < 6){ pwNew.focus(); return; }
      if (!mp){ pwMaster.focus(); return; }
      targetForm.querySelector('input[name="new_password"]').value = np;
      targetForm.querySelector('input[name="master_password"]').value = mp;
      setTimeout(()=>{ if (typeof targetForm.requestSubmit==='function') targetForm.requestSubmit(); else targetForm.submit(); hide(); },0);
    });
    document.addEventListener('keydown', (e)=>{ if(e.key==='Escape') hide(); });
    pwModal.show = show; pwModal.hide = hide;
  }
  function openPwModal(label, form){ ensurePwModal(); targetForm=form; pwNew.value=''; pwMaster.value=''; if(pwDesc) pwDesc.textContent='Enter a new password and master password to '+label+'.'; pwModal.show(); }

  // Delegate change password open buttons
  document.addEventListener('click', function(ev){
    const btn = ev.target.closest('.js-open-change-password');
    if (!btn) return;
    ev.preventDefault();
    const scope = btn.closest('.ag-card') || btn.closest('tr') || document;
    const form = scope.querySelector('.js-hidden-reset-form');
    if (form){
      const name = btn.getAttribute('data-agent-name') || 'this agent';
      openPwModal('change password for '+name, form);
    }
  });

  // ===== Agent Settings Modal (full parity controls) =====
  let setOverlay=null,setModal=null,setForm=null;
  let fldCommission=null,fldMaster=null;
  let fldAllowWallet=null,fldRequireTx=null,fldDailyLimit=null;
  let fldApiEnabled=null,fldAllowExtraMargin=null,fldMaxMargin=null,fldMaxFlat=null;
  let fldWalletPay=null, fldGatewayBooking=null, fldMarkupType=null;
  let fldApiKey=null, btnGenApi=null;
  let fldTxPassword=null, btnViewPin=null, statusBox=null;
  function ensureSettingsModal(){
    if (setOverlay) return;
    setOverlay=document.createElement('div'); setOverlay.style.cssText='position:fixed;inset:0;background:rgba(0,0,0,.45);display:none;z-index:21000;';
    setModal=document.createElement('div'); setModal.style.cssText='position:fixed;left:50%;top:50%;transform:translate(-50%,-50%);background:#fff;border-radius:8px;box-shadow:0 10px 30px rgba(0,0,0,.2);width:min(95vw,520px);max-height:90vh;overflow:auto;z-index:21001;display:none;';
    const hdr=document.createElement('div'); hdr.style.cssText='padding:10px 12px;border-bottom:1px solid #eee;font-weight:600;display:flex;justify-content:space-between;align-items:center;'; hdr.innerHTML='<span>Agent Settings</span>';
    const x=document.createElement('button'); x.type='button'; x.textContent='×'; x.style.cssText='border:0;background:transparent;font-size:20px;line-height:1;cursor:pointer;'; hdr.appendChild(x);
    const body=document.createElement('div'); body.style.cssText='padding:12px;';
    setForm=document.createElement('form'); setForm.method='post'; setForm.action='/admin/management/agents/settings';
    setForm.innerHTML = `
      <input type="hidden" name="csrf" value="<?= htmlspecialchars($csrf ?? '') ?>">
      <input type="hidden" name="id" value="">
      
      <div class="row g-3">
        <!-- General -->
        <div class="col-12"><div class="fw-semibold">General</div><hr class="my-2"></div>
        <div class="col-md-6">
          <label class="form-label">Require TX Password</label>
          <div class="form-check form-switch mt-1">
            <input class="form-check-input" type="checkbox" name="require_tx_password" checked>
            <label class="form-check-label">Require transaction password for sensitive ops</label>
          </div>
        </div>

        <!-- API Access -->
        <div class="col-12 mt-1"><div class="fw-semibold">API Access</div><hr class="my-2"></div>
        <div class="col-md-6">
          <label class="form-label">Enable API</label>
          <div class="form-check form-switch mt-1">
            <input class="form-check-input" type="checkbox" name="api_enabled">
            <label class="form-check-label">Enable API for this agent</label>
          </div>
        </div>
        <div class="col-md-6 d-flex align-items-end justify-content-end gap-2">
          <button type="button" class="btn btn-outline-primary btn-sm js-gen-api" title="Generate API Credentials">Generate</button>
          <button type="button" class="btn btn-outline-warning btn-sm js-rotate-api d-none" title="Rotate API Credentials">Rotate</button>
        </div>
        <div class="col-md-6">
          <label class="form-label">API Key</label>
          <div class="input-group">
            <input type="password" class="form-control" name="api_key_display" placeholder="API Key (generated)" readonly>
            <button type="button" class="btn btn-outline-secondary btn-sm js-toggle-vis" data-target="api_key_display" title="Show/Hide"><i class="bi bi-eye"></i></button>
            <button type="button" class="btn btn-outline-secondary btn-sm js-copy" data-target="api_key_display" title="Copy"><i class="bi bi-clipboard"></i></button>
          </div>
        </div>
        

        <!-- Pricing & Partner Margin for Channel partner to agent -->
        <div class="col-12 mt-1"><div class="fw-semibold">Pricing & Partner Margin for Channel partner to agent</div><hr class="my-2"></div>
        <div class="col-12">
          <label class="form-label">Markup Type</label>
          <div class="d-flex gap-3 align-items-center">
            <div class="form-check">
              <input class="form-check-input" type="radio" name="markup_type" value="percent" id="agMarkupPercent" checked>
              <label class="form-check-label" for="agMarkupPercent">Percent</label>
            </div>
            <div class="form-check">
              <input class="form-check-input" type="radio" name="markup_type" value="flat" id="agMarkupFlat">
              <label class="form-check-label" for="agMarkupFlat">Flat</label>
            </div>
          </div>
        </div>
        <div class="col-md-6">
          <label class="form-label">Max Margin Percent</label>
          <input type="number" step="0.01" class="form-control" name="max_margin_percent" placeholder="e.g. 10">
        </div>
        <div class="col-md-6">
          <label class="form-label">Max Flat Markup</label>
          <input type="number" step="0.01" class="form-control" name="max_flat_markup" placeholder="e.g. 50.00">
        </div>
        <div class="col-md-6">
          <label class="form-label">Enable Channel Partner Margin on Agent</label>
          <div class="form-check form-switch mt-1">
            <input class="form-check-input" type="checkbox" name="allow_extra_margin">
            <label class="form-check-label">Use channel partner margin for this agent</label>
          </div>
        </div>

        <!-- Booking Options -->
        <div class="col-12 mt-1"><div class="fw-semibold">Booking Options</div><hr class="my-2"></div>
        <div class="col-md-6">
          <label class="form-label">Wallet Booking</label>
          <div class="form-check form-switch mt-1">
            <input class="form-check-input" type="checkbox" name="wallet_pay_enabled" checked>
            <label class="form-check-label">Enable booking using wallet</label>
          </div>
        </div>
        <div class="col-md-6">
          <label class="form-label">Gateway Booking</label>
          <div class="form-check form-switch mt-1">
            <input class="form-check-input" type="checkbox" name="gateway_booking_enabled" checked>
            <label class="form-check-label">Enable booking via payment gateway</label>
          </div>
        </div>
        
        <div class="col-md-6">
          <label class="form-label">Daily Spend Limit</label>
          <input type="number" step="0.01" class="form-control" name="wallet_transfer_daily_limit" placeholder="e.g. 1000.00">
          <div class="small text-muted mt-1">Max total amount the agent can spend via wallet per day.</div>
        </div>

        <!-- Security -->
        <div class="col-12 mt-1"><div class="fw-semibold">Security</div><hr class="my-2"></div>
        <div class="col-12">
          <div class="border rounded p-2">
            <div class="d-flex justify-content-between align-items-center">
              <div>
                <div class="fw-semibold">Transaction PIN</div>
                <div class="small text-muted">6 digits. Leave blank to keep unchanged.</div>
              </div>
              <div>
                <button type="button" class="btn btn-outline-secondary btn-sm js-view-pin" title="View PIN"><i class="bi bi-eye"></i> View PIN</button>
              </div>
            </div>
            <div class="mt-2">
              <input type="password" inputmode="numeric" pattern="\\d{6}" maxlength="6" class="form-control" name="transaction_password" placeholder="Enter new 6-digit PIN">
            </div>
          </div>
        </div>
        <div class="col-12">
          <label class="form-label">Master Password</label>
          <input type="password" class="form-control" name="master_password" placeholder="Confirm with Admin Master Password">
        </div>
      </div>
    `;
    body.appendChild(setForm);
    const status=document.createElement('div'); status.className='small'; status.style.cssText='padding:8px 12px;display:none;'; body.appendChild(status); statusBox = status;
    const ftr=document.createElement('div'); ftr.style.cssText='padding:10px 12px;border-top:1px solid #eee;display:flex;justify-content:flex-end;gap:8px;';
    const cancel=document.createElement('button'); cancel.type='button'; cancel.className='btn btn-outline-secondary btn-sm'; cancel.textContent='Cancel';
    const save=document.createElement('button'); save.type='button'; save.className='btn btn-primary btn-sm js-settings-save'; save.textContent='Save Settings';
    ftr.appendChild(cancel); ftr.appendChild(save);
    setModal.appendChild(hdr); setModal.appendChild(body); setModal.appendChild(ftr);
    document.body.appendChild(setOverlay); document.body.appendChild(setModal);
    function show(){ setOverlay.style.display='block'; setModal.style.display='block'; }
    function hide(){ setOverlay.style.display='none'; setModal.style.display='none'; }
    setOverlay.addEventListener('click', hide); x.addEventListener('click', hide); cancel.addEventListener('click', hide);
    setModal.show = show; setModal.hide = hide;
    // Optional fields (may not exist depending on agent features)
    fldCommission = setForm.querySelector('input[name="commission_percent"]');
    fldMaster = setForm.querySelector('input[name="master_password"]');
    fldAllowWallet = setForm.querySelector('input[name="allow_wallet_transfer"]');
    fldRequireTx = setForm.querySelector('input[name="require_tx_password"]');
    fldDailyLimit = setForm.querySelector('input[name="wallet_transfer_daily_limit"]');
    fldApiEnabled = setForm.querySelector('input[name="api_enabled"]');
    fldAllowExtraMargin = setForm.querySelector('input[name="allow_extra_margin"]');
    fldMaxMargin = setForm.querySelector('input[name="max_margin_percent"]');
    fldMaxFlat = setForm.querySelector('input[name="max_flat_markup"]');
    fldWalletPay = setForm.querySelector('input[name="wallet_pay_enabled"]');
    fldGatewayBooking = setForm.querySelector('input[name="gateway_booking_enabled"]');
    fldMarkupType = setForm.querySelectorAll('input[name="markup_type"]');
    fldApiKey = setForm.querySelector('input[name="api_key_display"]');
    btnGenApi = setForm.querySelector('.js-gen-api');
    const btnRotateApi = setForm.querySelector('.js-rotate-api');
    fldTxPassword = setForm.querySelector('input[name="transaction_password"]');
    btnViewPin = setForm.querySelector('.js-view-pin');
    // Submit via AJAX
    setForm.addEventListener('submit', async function(ev){
      ev.preventDefault();
      status.style.display='none'; status.textContent=''; status.className='small';
      const fd = new FormData(setForm);
      const btn = setModal.querySelector('.js-settings-save');
      if (btn) { btn.disabled = true; btn.textContent = 'Saving…'; }
      try {
        const res = await fetch(setForm.action, { method:'POST', body: fd, headers: { 'Accept':'application/json','X-Requested-With':'XMLHttpRequest' } });
        const data = await res.json().catch(()=>({ ok:false, error:'Invalid JSON' }));
        if (!res.ok || !data.ok){
          status.textContent = (data && (data.error||data.message|| (data.errors? data.errors.join('; '):''))) || 'Failed to save.';
          status.style.display='block'; status.style.color='#b02a37';
        } else {
          status.textContent = data.message || 'Saved.';
          status.style.display='block'; status.style.color='#0a7d38';
        }
      } catch(err){
        status.textContent = 'Network error while saving.';
        status.style.display='block'; status.style.color='#b02a37';
      } finally {
        if (btn) { btn.disabled = false; btn.textContent = 'Save Settings'; }
      }
    });

    function applyMarkupUi(){
      let type = 'percent';
      fldMarkupType.forEach(r=>{ if(r.checked) type = r.value; });
      if (type === 'percent'){
        fldMaxMargin.removeAttribute('disabled');
        fldMaxFlat.setAttribute('disabled','disabled');
      } else {
        fldMaxFlat.removeAttribute('disabled');
        fldMaxMargin.setAttribute('disabled','disabled');
      }
    }
    fldMarkupType.forEach(r=> r.addEventListener('change', applyMarkupUi));

    applyMarkupUi();

    // Generate/View API button
    btnGenApi.addEventListener('click', async ()=>{
      const mode = btnGenApi.getAttribute('data-mode') || 'generate';
      const id = setForm.querySelector('input[name="id"]').value;
      if (!id){ alert('Agent id missing. Please open Settings from the agent row.'); return; }
      if (mode === 'view'){
        const key = (fldApiKey && fldApiKey.value) ? fldApiKey.value : '';
        if (!key){ alert('No API Key stored.'); return; }
        const ok = confirm('API Key: '+key+'\n\nCopy to clipboard?');
        if (ok) { try { await navigator.clipboard.writeText(key); alert('Copied.'); } catch(e){ /* ignore */ } }
        return;
      }
      // generate flow
      if (!fldApiEnabled.checked){ alert('Enable API access first, save settings, then try again.'); return; }
      // Prefer the modal's master password field if provided; fall back to prompt
      let mp = (fldMaster && fldMaster.value) ? fldMaster.value.trim() : '';
      if (!mp){ mp = prompt('Enter Admin Master Password to generate API credentials:') || ''; }
      if (!mp){ return; }
      const fd = new FormData();
      fd.append('csrf', '<?= htmlspecialchars($csrf ?? '') ?>');
      fd.append('id', id);
      fd.append('master_password', mp);
      try{
        btnGenApi.disabled = true; const oldTxt = btnGenApi.textContent; btnGenApi.textContent = 'Generating…';
        const res = await fetch('/admin/management/agents/settings/api_generate', {method:'POST', body: fd, headers: {'Accept':'application/json','X-Requested-With':'XMLHttpRequest'}});
        const js = await res.json().catch(()=>({}));
        if (!res.ok || (js && js.ok === false)){
          const msg = (js && (js.error||js.message)) || ('Failed ('+res.status+').');
          alert('Failed to generate API credentials: ' + msg);
          return;
        }
        fldApiKey.value = (js && js.api_key) || '';
        // switch to view mode now that key exists
        btnGenApi.textContent = 'View API';
        btnGenApi.setAttribute('data-mode','view');
        // show rotate button when key exists
        if (btnRotateApi) btnRotateApi.classList.remove('d-none');
        // Show API secret once for copying
        if (js && js.api_secret){
          alert('API Secret (copy now, will not be shown again):\n\n' + js.api_secret);
        }
      }catch(e){ alert('Network error.'); }
      finally { btnGenApi.disabled = false; if (!btnGenApi.getAttribute('data-mode')) btnGenApi.textContent='Generate'; }
    });

    // Rotate API button (re-generate credentials)
    if (btnRotateApi){
      btnRotateApi.addEventListener('click', async ()=>{
        const id = setForm.querySelector('input[name="id"]').value;
        if (!id){ alert('Agent id missing. Please open Settings from the agent row.'); return; }
        if (!fldApiEnabled.checked){ alert('Enable API access first, save settings, then try again.'); return; }
        const ok = confirm('Rotate API credentials? This will invalidate the existing key.');
        if (!ok) return;
        // Prefer the modal's master password field if provided; fall back to prompt
        let mp = (fldMaster && fldMaster.value) ? fldMaster.value.trim() : '';
        if (!mp){ mp = prompt('Enter Admin Master Password to rotate API credentials:') || ''; }
        if (!mp){ return; }
        const fd = new FormData();
        fd.append('csrf', '<?= htmlspecialchars($csrf ?? '') ?>');
        fd.append('id', id);
        fd.append('master_password', mp);
        try{
          btnRotateApi.disabled = true; const oldTxt = btnRotateApi.textContent; btnRotateApi.textContent = 'Rotating…';
          const res = await fetch('/admin/management/agents/settings/api_generate', {method:'POST', body: fd, headers: {'Accept':'application/json','X-Requested-With':'XMLHttpRequest'}});
          const js = await res.json().catch(()=>({}));
          if (!res.ok || (js && js.ok === false)){
            const msg = (js && (js.error||js.message)) || ('Failed ('+res.status+').');
            alert('Failed to rotate API credentials: ' + msg);
            return;
          }
          fldApiKey.value = (js && js.api_key) || '';
          // ensure view mode and show secret once
          btnGenApi.textContent = 'View API';
          btnGenApi.setAttribute('data-mode','view');
          if (btnRotateApi) btnRotateApi.classList.remove('d-none');
          if (js && js.api_secret){
            alert('New API Secret (copy now, will not be shown again):\n\n' + js.api_secret);
          }
        }catch(e){ alert('Network error.'); }
        finally { btnRotateApi.disabled = false; btnRotateApi.textContent = 'Rotate'; }
      });
    }

    // View PIN handler (prompts for master password)
    btnViewPin.addEventListener('click', async ()=>{
      const id = setForm.querySelector('input[name="id"]').value;
      if (!id) return;
      const mp = prompt('Enter Admin Master Password to view PIN:');
      if (!mp) return;
      const fd = new FormData();
      fd.append('csrf', '<?= htmlspecialchars($csrf ?? '') ?>');
      fd.append('id', id);
      fd.append('master_password', mp);
      try {
        const res = await fetch('/admin/management/agents/settings/view_pin', { method:'POST', body: fd, headers:{ 'Accept':'application/json','X-Requested-With':'XMLHttpRequest' } });
        const data = await res.json().catch(()=>({}));
        if (res.ok && data && data.pin){
          alert('Transaction PIN: ' + data.pin);
        } else {
          const err = (data && (data.error||data.message)) || 'Failed to view PIN.';
          alert(err);
        }
      } catch (e){ alert('Network error.'); }
    });
  }
  async function openSettings(agentId){
    ensureSettingsModal();
    setForm.reset();
    if (!agentId){ alert('Invalid agent id. Please use the Settings button on an agent row.'); return; }
    setForm.querySelector('input[name="id"]').value = agentId;
    try {
      const res = await fetch(`/admin/management/agents/settings?id=${agentId}`, { headers:{ 'Accept':'application/json' } });
      if (res.ok){
        const s = await res.json();
        if (fldCommission && typeof s.commission_percent !== 'undefined' && s.commission_percent !== null) {
          fldCommission.value = s.commission_percent;
        }
        // Populate parity fields
        if (typeof s.api_enabled !== 'undefined') fldApiEnabled.checked = !!Number(s.api_enabled);
        if (typeof s.allow_extra_margin !== 'undefined') fldAllowExtraMargin.checked = !!Number(s.allow_extra_margin);
        if (typeof s.max_margin_percent !== 'undefined' && s.max_margin_percent !== null) fldMaxMargin.value = s.max_margin_percent;
        if (typeof s.max_flat_markup !== 'undefined' && s.max_flat_markup !== null) fldMaxFlat.value = s.max_flat_markup;
        if (fldAllowWallet && typeof s.allow_wallet_transfer !== 'undefined') fldAllowWallet.checked = !!Number(s.allow_wallet_transfer);
        if (typeof s.require_tx_password !== 'undefined') fldRequireTx.checked = !!Number(s.require_tx_password);
        if (typeof s.wallet_transfer_daily_limit !== 'undefined' && s.wallet_transfer_daily_limit !== null) fldDailyLimit.value = s.wallet_transfer_daily_limit;
        if (typeof s.wallet_pay_enabled !== 'undefined') fldWalletPay.checked = !!Number(s.wallet_pay_enabled);
        if (typeof s.gateway_booking_enabled !== 'undefined') fldGatewayBooking.checked = !!Number(s.gateway_booking_enabled);
        if (typeof s.api_key !== 'undefined' && s.api_key) fldApiKey.value = s.api_key;
        // Toggle button mode based on presence of API key
        if (fldApiKey && fldApiKey.value){
          btnGenApi.textContent='View API';
          btnGenApi.setAttribute('data-mode','view');
          const btnRotateApi = setForm.querySelector('.js-rotate-api');
          if (btnRotateApi) btnRotateApi.classList.remove('d-none');
        } else {
          btnGenApi.textContent='Generate';
          btnGenApi.setAttribute('data-mode','generate');
          const btnRotateApi = setForm.querySelector('.js-rotate-api');
          if (btnRotateApi) btnRotateApi.classList.add('d-none');
        }
        // Decide markup type based on which value exists
        let type = 'percent';
        if (s.max_flat_markup !== null && typeof s.max_flat_markup !== 'undefined' && s.max_flat_markup !== '') type = 'flat';
        setForm.querySelector(`input[name="markup_type"][value="${type}"]`).checked = true;
        applyMarkupUi();
      }
    } catch(e){ /* ignore */ }
    // If API is disabled, ensure button shows Generate and hide Rotate
    if (!fldApiEnabled.checked){
      btnGenApi.textContent='Generate';
      btnGenApi.setAttribute('data-mode','generate');
      const btnRotateApi = setForm.querySelector('.js-rotate-api');
      if (btnRotateApi) btnRotateApi.classList.add('d-none');
    }
    setModal.show();
  }

  document.addEventListener('click', function(e){
    const s = e.target.closest('.js-open-settings');
    if (!s) return;
    e.preventDefault();
    const id = s.getAttribute('data-agent-id');
    if (!id){ alert('Missing agent id.'); return; }
    openSettings(id);
  });

  // Toggle visibility and Copy handlers for input groups
  document.addEventListener('click', async (e)=>{
    const t1 = e.target.closest('.js-toggle-vis');
    if (t1){
      e.preventDefault();
      const name = t1.getAttribute('data-target');
      const inp = setForm ? setForm.querySelector(`input[name="${name}"]`) : null;
      if (inp){ inp.type = (inp.type === 'password') ? 'text' : 'password'; }
      return;
    }
    const t2 = e.target.closest('.js-copy');
    if (t2){
      e.preventDefault();
      const name = t2.getAttribute('data-target');
      const inp = setForm ? setForm.querySelector(`input[name="${name}"]`) : null;
      if (inp && inp.value){ try { await navigator.clipboard.writeText(inp.value); t2.textContent='Copied'; setTimeout(()=>{ t2.textContent='Copy'; }, 1200); } catch(_){} }
    }
  });

  // Delegate settings save button
  document.addEventListener('click', (e)=>{
    if (e.target && e.target.classList && e.target.classList.contains('js-settings-save')){
      e.preventDefault();
      if (setForm) setForm.dispatchEvent(new Event('submit', { cancelable:true }));
    }
  });
})();
</script>
