<?php
// app/Views/admin/kyc_show.php
use App\Core\Security;
?>
<div class="container py-2">
  <div class="d-flex align-items-center justify-content-between mb-2">
    <div>
      <a href="/admin/kyc" class="btn btn-sm btn-outline-secondary me-2">← Back</a>
      <span class="h6 mb-0 align-middle"><i class="bi bi-shield-check me-2"></i>KYC Review</span>
    </div>
    <div class="d-none d-md-flex align-items-center gap-2">
      <form method="post" action="/admin/kyc/approve" class="d-inline">
        <input type="hidden" name="csrf" value="<?= htmlspecialchars($csrf ?? '') ?>">
        <input type="hidden" name="id" value="<?= (int)($kyc['id'] ?? 0) ?>">
        <button class="btn btn-success btn-sm" type="submit" <?= (($kyc['status'] ?? '')==='approved')?'disabled':''; ?>>Approve</button>
      </form>
      <form method="post" action="/admin/kyc/reject" class="d-inline">
        <input type="hidden" name="csrf" value="<?= htmlspecialchars($csrf ?? '') ?>">
        <input type="hidden" name="id" value="<?= (int)($kyc['id'] ?? 0) ?>">
        <div class="input-group input-group-sm" style="max-width:420px">
          <input type="text" name="remarks" class="form-control" placeholder="Remarks (optional)">
          <button class="btn btn-outline-danger" type="submit" <?= (($kyc['status'] ?? '')==='rejected')?'disabled':''; ?>>Reject</button>
        </div>
      </form>
    </div>
  </div>

  <div class="row g-3">
    <div class="col-md-6">
      <div class="card shadow-sm border-0 rounded-3">
        <div class="card-body p-3">
          <div class="mb-2"><strong>User:</strong> <?= Security::sanitize($kyc['name'] ?? '') ?> (<?= Security::sanitize($kyc['email'] ?? '') ?>)</div>
          <?php if (!empty($kyc['agency_name'])): ?>
            <div class="mb-2"><strong>Agency:</strong> <?= Security::sanitize($kyc['agency_name']) ?></div>
          <?php endif; ?>
          <?php if (!empty($kyc['company'])): ?>
            <div class="mb-2"><strong>Company:</strong> <?= Security::sanitize($kyc['company']) ?></div>
          <?php endif; ?>
          <?php if (!empty($kyc['business_type'])): ?>
            <div class="mb-2"><strong>Business Type:</strong> <span class="badge bg-info text-dark"><?= Security::sanitize($kyc['business_type']) ?></span></div>
          <?php endif; ?>
          <?php if (!empty($kyc['phone'])): ?>
            <div class="mb-2"><strong>Phone:</strong> <?= Security::sanitize($kyc['phone']) ?></div>
          <?php endif; ?>

          <div class="mb-2"><strong>ID Type:</strong> <span class="badge bg-secondary"><?= Security::sanitize($kyc['id_type'] ?? '') ?></span></div>
          <div class="mb-2"><strong>ID Number:</strong> <?= Security::sanitize($kyc['id_number'] ?? '') ?></div>

          <div class="mb-2"><strong>Address:</strong>
            <div class="small">
              <?= Security::sanitize(trim(($kyc['address_line'] ?? ''))) ?>
              <?php $city = trim((string)($kyc['city'] ?? '')); $state = trim((string)($kyc['state'] ?? '')); $pin = trim((string)($kyc['pincode'] ?? '')); $country = trim((string)($kyc['country'] ?? '')); ?>
              <?php if ($city || $state || $pin || $country): ?>
                <div><?= Security::sanitize(implode(', ', array_filter([$city, $state, $pin, $country]))) ?></div>
              <?php endif; ?>
            </div>
          </div>

          <?php if (!empty($kyc['gst_number']) || !empty($kyc['gst_company'])): ?>
            <div class="mb-2"><strong>GST:</strong>
              <div class="small">Number: <?= Security::sanitize($kyc['gst_number'] ?? '') ?></div>
              <div class="small">Company: <?= Security::sanitize($kyc['gst_company'] ?? '') ?></div>
            </div>
          <?php endif; ?>

          <?php if (isset($kyc['iata_registered'])): ?>
            <div class="mb-2"><strong>IATA:</strong>
              <?php if ((int)$kyc['iata_registered'] === 1): ?>
                <span class="badge bg-success">Registered</span>
                <?php if (!empty($kyc['iata_code'])): ?>
                  <span class="ms-2">Code: <?= Security::sanitize($kyc['iata_code']) ?></span>
                <?php endif; ?>
              <?php else: ?>
                <span class="badge bg-secondary">Not Registered</span>
              <?php endif; ?>
            </div>
          <?php endif; ?>

          <div class="mb-2"><strong>Status:</strong>
            <?php if (($kyc['status'] ?? '')==='pending'): ?>
              <span class="badge bg-warning text-dark">pending</span>
            <?php elseif (($kyc['status'] ?? '')==='approved'): ?>
              <span class="badge bg-success">approved</span>
            <?php else: ?>
              <span class="badge bg-danger">rejected</span>
            <?php endif; ?>
          </div>
          <?php if (!empty($kyc['remarks'])): ?>
            <div class="mb-2"><strong>Remarks:</strong> <?= Security::sanitize($kyc['remarks']) ?></div>
          <?php endif; ?>
          <?php if (!empty($kyc['verified_at'])): ?>
            <div class="mb-2"><strong>Verified at:</strong> <?= Security::sanitize($kyc['verified_at']) ?></div>
          <?php endif; ?>
        </div>
      </div>
    </div>
    <div class="col-md-6">
      <div class="card shadow-sm border-0 rounded-3">
        <div class="card-body p-3">
          <div class="mb-2"><strong>Documents</strong></div>
          <div class="mb-3">
            <div class="small text-muted">Front</div>
            <?php $front = $kyc['doc_front_path'] ?? ''; ?>
            <?php if ($front): ?>
              <!-- Encrypted streaming route will output correct mime, so direct <img> works -->
              <a href="/admin/kyc/file?id=<?= (int)($kyc['id'] ?? 0) ?>&side=front" target="_blank" rel="noopener">
                <img src="/admin/kyc/file?id=<?= (int)($kyc['id'] ?? 0) ?>&side=front" class="img-thumbnail" style="max-height:160px" alt="KYC Front">
              </a>
            <?php else: ?>
              <span class="text-muted">Not uploaded</span>
            <?php endif; ?>
          </div>
          <div class="mb-3">
            <div class="small text-muted">Back</div>
            <?php $back = $kyc['doc_back_path'] ?? ''; ?>
            <?php if ($back): ?>
              <a href="/admin/kyc/file?id=<?= (int)($kyc['id'] ?? 0) ?>&side=back" target="_blank" rel="noopener">
                <img src="/admin/kyc/file?id=<?= (int)($kyc['id'] ?? 0) ?>&side=back" class="img-thumbnail" style="max-height:160px" alt="KYC Back">
              </a>
            <?php else: ?>
              <span class="text-muted">Not uploaded</span>
            <?php endif; ?>
          </div>
          <?php if (!empty($docs)): ?>
            <hr>
            <div class="mb-2"><strong>Business Documents</strong></div>
            <div class="row g-2">
              <?php foreach ($docs as $d): ?>
                <?php $p = $d['file_path'] ?? ''; $img = true; // stream route will serve correct mime ?>
                <div class="col-12 d-flex align-items-center">
                  <span class="badge bg-light text-dark border me-2 text-capitalize"><?= Security::sanitize($d['doc_type'] ?? '') ?></span>
                  <?php if (!empty($p)): ?>
                    <a href="/admin/kyc/doc?id=<?= (int)($d['id'] ?? 0) ?>" target="_blank" rel="noopener" class="me-2">
                      <img src="/admin/kyc/doc?id=<?= (int)($d['id'] ?? 0) ?>" class="img-thumbnail" style="max-height:64px" alt="<?= Security::sanitize($d['doc_type'] ?? 'Doc') ?>">
                    </a>
                    <a class="link-primary small" href="/admin/kyc/doc?id=<?= (int)($d['id'] ?? 0) ?>" target="_blank" rel="noopener">Open</a>
                  <?php else: ?>
                    <span class="text-muted small">Missing</span>
                  <?php endif; ?>
                </div>
              <?php endforeach; ?>
            </div>
          <?php endif; ?>
        </div>
      </div>
    </div>
  </div>
  <!-- Mobile action bar -->
  <div class="mt-3 d-flex d-md-none flex-column gap-2">
    <form method="post" action="/admin/kyc/approve" class="d-inline">
      <input type="hidden" name="csrf" value="<?= htmlspecialchars($csrf ?? '') ?>">
      <input type="hidden" name="id" value="<?= (int)($kyc['id'] ?? 0) ?>">
      <button class="btn btn-success w-100" type="submit" <?= (($kyc['status'] ?? '')==='approved')?'disabled':''; ?>>Approve</button>
    </form>
    <form method="post" action="/admin/kyc/reject" class="d-inline">
      <input type="hidden" name="csrf" value="<?= htmlspecialchars($csrf ?? '') ?>">
      <input type="hidden" name="id" value="<?= (int)($kyc['id'] ?? 0) ?>">
      <div class="input-group">
        <input type="text" name="remarks" class="form-control" placeholder="Remarks (optional)">
        <button class="btn btn-outline-danger" type="submit" <?= (($kyc['status'] ?? '')==='rejected')?'disabled':''; ?>>Reject</button>
      </div>
    </form>
  </div>
</div>
