<?php
// app/Views/admin/corporates/index.php
?>
<div class="container py-4">
  <div class="d-flex align-items-center justify-content-between mb-3">
    <h1 class="h4 mb-0">Corporate Accounts</h1>
    <div>
      <a href="/admin/corporates/create" class="btn btn-sm btn-primary">New Corporate</a>
      <a href="/admin" class="btn btn-sm btn-outline-secondary">Dashboard</a>
    </div>
  </div>

  <?php if (!empty($_SESSION['flash'])): ?>
    <div class="alert alert-info py-2"><?php echo htmlspecialchars($_SESSION['flash']); unset($_SESSION['flash']); ?></div>
  <?php endif; ?>

  <div class="card shadow-sm">
    <div class="table-responsive">
      <table class="table align-middle mb-0">
        <thead>
          <tr>
            <th>ID</th>
            <th>Company</th>
            <th>Discount %</th>
            <th></th>
          </tr>
        </thead>
        <tbody>
          <?php if (!empty($rows)): foreach ($rows as $r): ?>
            <tr>
              <td>#<?php echo (int)$r['id']; ?></td>
              <td><?php echo htmlspecialchars($r['company_name']); ?></td>
              <td><?php echo number_format((float)$r['discount_percent'], 2); ?></td>
              <td class="text-end">
                <a class="btn btn-sm btn-outline-primary" href="/admin/corporates/edit?id=<?php echo (int)$r['id']; ?>">Edit</a>
                <form method="post" action="/admin/corporates/delete" class="d-inline" onsubmit="return confirm('Delete this corporate?');">
                  <input type="hidden" name="csrf_token" value="<?php echo htmlspecialchars(\App\Core\Security::csrfToken()); ?>" />
                  <input type="hidden" name="id" value="<?php echo (int)$r['id']; ?>" />
                  <button class="btn btn-sm btn-outline-danger">Delete</button>
                </form>
              </td>
            </tr>
          <?php endforeach; else: ?>
            <tr>
              <td colspan="4" class="text-center text-muted py-4">No corporate accounts.</td>
            </tr>
          <?php endif; ?>
        </tbody>
      </table>
    </div>
  </div>
</div>
