<div class="container-xxl py-3">
  <nav aria-label="breadcrumb" class="mb-3">
    <ol class="breadcrumb mb-0">
      <li class="breadcrumb-item"><a href="/admin">Dashboard</a></li>
      <li class="breadcrumb-item"><a href="/admin/bank-accounts">Company Bank Accounts</a></li>
      <li class="breadcrumb-item active" aria-current="page"><?php echo htmlspecialchars(($mode ?? '')==='edit' ? 'Edit Bank Account' : 'Add Bank Account'); ?></li>
    </ol>
  </nav>
  <h1 class="h4 mb-3"><?php echo htmlspecialchars(($mode ?? '')==='edit' ? 'Edit Bank Account' : 'Add Bank Account'); ?></h1>

  <?php if (!empty($_SESSION['flash_error'])): ?>
    <div class="alert alert-danger border-0 shadow-sm mb-3"><?php echo htmlspecialchars($_SESSION['flash_error']); unset($_SESSION['flash_error']); ?></div>
  <?php endif; ?>
  <?php if (!empty($_SESSION['flash_success'])): ?>
    <div class="alert alert-success border-0 shadow-sm mb-3"><?php echo htmlspecialchars($_SESSION['flash_success']); unset($_SESSION['flash_success']); ?></div>
  <?php endif; ?>

  <?php $row = $row ?? ['bank_name'=>'','account_name'=>'','account_number'=>'','branch'=>'','swift_code'=>'','ifsc'=>'','currency'=>'THB','active'=>1,'notes'=>'']; ?>
  <div class="row g-3">
    <div class="col-12 col-lg-8">
      <div class="card card-elevated">
        <div class="card-body">
          <form action="<?php echo ($mode ?? '')==='edit' ? '/admin/bank-accounts/update' : '/admin/bank-accounts/store'; ?>" method="post" class="row g-3">
            <input type="hidden" name="csrf" value="<?php echo \App\Core\Security::csrfToken(); ?>" />
            <?php if (($mode ?? '')==='edit'): ?>
              <input type="hidden" name="id" value="<?php echo (int)($row['id'] ?? 0); ?>" />
            <?php endif; ?>
            <div class="col-12">
              <label class="form-label">Bank Name</label>
              <input type="text" name="bank_name" value="<?php echo htmlspecialchars($row['bank_name']); ?>" required class="form-control" />
            </div>
            <div class="col-md-6">
              <label class="form-label">Account Name</label>
              <input type="text" name="account_name" value="<?php echo htmlspecialchars($row['account_name']); ?>" required class="form-control" />
            </div>
            <div class="col-md-6">
              <label class="form-label">Account Number</label>
              <input type="text" name="account_number" value="<?php echo htmlspecialchars($row['account_number']); ?>" required class="form-control" />
            </div>
            <div class="col-md-6">
              <label class="form-label">Branch</label>
              <input type="text" name="branch" value="<?php echo htmlspecialchars($row['branch']); ?>" class="form-control" />
            </div>
            <div class="col-md-6">
              <label class="form-label">SWIFT</label>
              <input type="text" name="swift_code" value="<?php echo htmlspecialchars($row['swift_code']); ?>" class="form-control" />
            </div>
            <div class="col-md-6">
              <label class="form-label">IFSC</label>
              <input type="text" name="ifsc" value="<?php echo htmlspecialchars($row['ifsc']); ?>" class="form-control" />
            </div>
            <div class="col-md-3">
              <label class="form-label">Currency</label>
              <input type="text" name="currency" value="<?php echo htmlspecialchars($row['currency']); ?>" class="form-control" />
            </div>
            <div class="col-md-3">
              <label class="form-label">Active</label>
              <select name="active" class="form-select">
                <option value="1" <?php echo ((int)$row['active']===1)?'selected':''; ?>>Yes</option>
                <option value="0" <?php echo ((int)$row['active']===0)?'selected':''; ?>>No</option>
              </select>
            </div>
            <div class="col-12">
              <label class="form-label">Notes</label>
              <textarea name="notes" class="form-control" rows="3"><?php echo htmlspecialchars($row['notes']); ?></textarea>
            </div>
            <div class="col-12 d-flex gap-2">
              <button class="btn btn-primary"><?php echo ($mode ?? '')==='edit' ? 'Update' : 'Create'; ?></button>
              <a href="/admin/bank-accounts" class="btn btn-outline-secondary">Cancel</a>
            </div>
          </form>
        </div>
      </div>
    </div>
  </div>
</div>
