<?php /** @var array $booking */ /** @var array $guests */ ?>
<div class="container py-3">
  <nav aria-label="breadcrumb">
    <ol class="breadcrumb">
      <li class="breadcrumb-item"><a href="/admin">Dashboard</a></li>
      <li class="breadcrumb-item"><a href="/admin/payments">Payments</a></li>
      <li class="breadcrumb-item active" aria-current="page">Hotel Booking #<?= (int)$booking['id'] ?></li>
    </ol>
  </nav>

  <div class="d-flex align-items-center justify-content-between mb-3">
    <h1 class="h4 mb-0">Hotel Booking #<?= (int)$booking['id'] ?></h1>
    <span class="badge bg-<?= (($booking['status'] ?? '')==='confirmed'?'success':(($booking['status'] ?? '')==='cancelled'?'danger':'warning-subtle text-dark')) ?> text-uppercase">
      <?= htmlspecialchars((string)($booking['status'] ?? 'pending')) ?>
    </span>
  </div>

  <div class="row g-3">
    <div class="col-lg-7">
      <div class="card">
        <div class="card-header"><i class="bi bi-building me-2"></i>Stay Details</div>
        <div class="card-body kv">
          <div class="text-muted">Hotel</div>
          <div><strong><?= htmlspecialchars((string)($booking['hotel_name'] ?? '')) ?></strong><?php if (!empty($booking['hotel_city'])): ?> • <?= htmlspecialchars((string)$booking['hotel_city']) ?><?php endif; ?><?php if (!empty($booking['hotel_country'])): ?>, <?= htmlspecialchars((string)$booking['hotel_country']) ?><?php endif; ?></div>

          <?php if (!empty($booking['room_name'])): ?>
          <div class="text-muted">Room</div>
          <div><?= htmlspecialchars((string)$booking['room_name']) ?></div>
          <?php endif; ?>

          <div class="text-muted">Booking Code</div>
          <div><span class="badge bg-light text-dark"><?= htmlspecialchars((string)$booking['booking_code']) ?></span></div>

          <div class="text-muted">Dates</div>
          <div>Check-in: <?= htmlspecialchars((string)$booking['checkin']) ?> • Check-out: <?= htmlspecialchars((string)$booking['checkout']) ?> (<?= (int)($booking['nights'] ?? 0) ?> nights)</div>

          <div class="text-muted">Rooms</div>
          <div><?= (int)($booking['rooms_qty'] ?? 1) ?></div>

          <div class="text-muted">Payment Status</div>
          <div><span class="badge bg-<?= (($booking['payment_status'] ?? '')==='paid'?'success':(($booking['payment_status'] ?? '')==='unpaid'?'secondary':'warning-subtle text-dark')) ?>"><?= htmlspecialchars(ucfirst((string)($booking['payment_status'] ?? ''))) ?></span></div>

          <div class="text-muted">Total</div>
          <div><?= htmlspecialchars((string)($booking['currency'] ?? '')) ?> <?= htmlspecialchars(number_format((float)($booking['total_price'] ?? 0), 2)) ?></div>
        </div>
      </div>

      <?php if (!empty($guests)): ?>
      <div class="card mt-3">
        <div class="card-header"><i class="bi bi-people me-2"></i>Guests</div>
        <div class="card-body">
          <ol class="mb-0">
            <?php foreach ($guests as $g): ?>
              <li>
                <?= htmlspecialchars(trim(((string)($g['title'] ?? '') . ' ' . ($g['first_name'] ?? '') . ' ' . ($g['last_name'] ?? '')))) ?>
                <?php if (!empty($g['age'])): ?>
                  <small class="text-muted">(Age: <?= (int)$g['age'] ?>)</small>
                <?php endif; ?>
              </li>
            <?php endforeach; ?>
          </ol>
        </div>
      </div>
      <?php elseif (!empty($booking['guests_adults']) || !empty($booking['guests_children'])): ?>
      <div class="card mt-3">
        <div class="card-header"><i class="bi bi-people me-2"></i>Guests</div>
        <div class="card-body">
          <div>Adults: <strong><?= (int)($booking['guests_adults'] ?? 0) ?></strong></div>
          <div>Children: <strong><?= (int)($booking['guests_children'] ?? 0) ?></strong></div>
        </div>
      </div>
      <?php endif; ?>
    </div>

    <div class="col-lg-5">
      <?php if (!empty($agency)): ?>
      <div class="card mb-3">
        <div class="card-header"><i class="bi bi-building me-2"></i>Agency</div>
        <div class="card-body kv">
          <?php if (!empty($agency['company'])): ?>
          <div class="text-muted">Company</div>
          <div><?= htmlspecialchars((string)$agency['company']) ?></div>
          <?php endif; ?>

          <?php if (!empty($agency['name'])): ?>
          <div class="text-muted">Agent</div>
          <div><?= htmlspecialchars((string)$agency['name']) ?></div>
          <?php endif; ?>

          <?php if (!empty($agency['email'])): ?>
          <div class="text-muted">Email</div>
          <div><a href="mailto:<?= htmlspecialchars((string)$agency['email']) ?>"><?= htmlspecialchars((string)$agency['email']) ?></a></div>
          <?php endif; ?>

          <?php if (!empty($agency['mobile'])): ?>
          <div class="text-muted">Mobile</div>
          <div><?= htmlspecialchars((string)$agency['mobile']) ?></div>
          <?php endif; ?>

          <?php if (!empty($agency['whatsapp'])): ?>
          <div class="text-muted">WhatsApp</div>
          <div><?= htmlspecialchars((string)$agency['whatsapp']) ?></div>
          <?php endif; ?>
        </div>
      </div>
      <?php endif; ?>

      <div class="card">
        <div class="card-header"><i class="bi bi-person-vcard me-2"></i>Customer</div>
        <div class="card-body kv">
          <?php if (!empty($booking['customer_name'])): ?>
          <div class="text-muted">Name</div>
          <div><?= htmlspecialchars((string)$booking['customer_name']) ?></div>
          <?php endif; ?>

          <?php if (!empty($booking['customer_email'])): ?>
          <div class="text-muted">Email</div>
          <div><a href="mailto:<?= htmlspecialchars((string)$booking['customer_email']) ?>"><?= htmlspecialchars((string)$booking['customer_email']) ?></a></div>
          <?php endif; ?>

          <?php if (!empty($booking['customer_mobile'])): ?>
          <div class="text-muted">Mobile</div>
          <div><?= htmlspecialchars((string)$booking['customer_mobile']) ?></div>
          <?php endif; ?>

          <?php if (!empty($booking['customer_whatsapp'])): ?>
          <div class="text-muted">WhatsApp</div>
          <div><?= htmlspecialchars((string)$booking['customer_whatsapp']) ?></div>
          <?php endif; ?>

          <?php if (!empty($booking['special_requests'])): ?>
          <div class="text-muted">Special Requests</div>
          <div><?= nl2br(htmlspecialchars((string)$booking['special_requests'])) ?></div>
          <?php endif; ?>
        </div>
      </div>

      <div class="card mt-3">
        <div class="card-header"><i class="bi bi-info-circle me-2"></i>Meta</div>
        <div class="card-body">
          <?php if (!empty($orderId)): ?>
            <div class="small text-muted">Order</div>
            <div class="mb-2 small"><a href="/admin/orders/view?id=<?= (int)$orderId ?>">#<?= (int)$orderId ?></a></div>
          <?php endif; ?>
          <div class="small text-muted">Created</div>
          <div class="mb-2 small">&nbsp;<?= htmlspecialchars((string)($booking['created_at'] ?? '')) ?></div>
          <?php if (!empty($booking['updated_at'])): ?>
            <div class="small text-muted">Updated</div>
            <div class="small">&nbsp;<?= htmlspecialchars((string)$booking['updated_at']) ?></div>
          <?php endif; ?>
        </div>
      </div>
    </div>
  </div>
</div>
