<?php
// app/Views/admin/booking_activity_create.php
?>
<div class="container py-2">
  <h2 class="h5 mb-3"><i class="bi bi-plus-circle me-2"></i>Add Activity Booking</h2>
  <form method="post" action="#" onsubmit="return false;">
    <div class="row g-3">
      <div class="col-md-4">
        <label class="form-label">Country</label>
        <select class="form-select" id="countrySelect" name="country" required>
          <option value="">-- Select Country --</option>
          <?php foreach (($countries ?? []) as $c): $cv = trim((string)($c['country'] ?? '')); if ($cv==='') continue; ?>
            <option value="<?= htmlspecialchars($cv) ?>"><?= htmlspecialchars($cv) ?></option>
          <?php endforeach; ?>
        </select>
      </div>
      <div class="col-md-4">
        <label class="form-label">City</label>
        <select class="form-select" id="citySelect" name="city" required disabled>
          <option value="">-- Select City --</option>
        </select>
      </div>
      <div class="col-md-4">
        <label class="form-label">Vendor</label>
        <select class="form-select" id="vendorSelect" name="vendor_id" required>
          <option value="">-- Select Vendor --</option>
          <?php foreach (($vendors ?? []) as $v): ?>
            <option value="<?= (int)$v['id'] ?>" data-country="<?= htmlspecialchars($v['country'] ?? '') ?>" data-city="<?= htmlspecialchars($v['city'] ?? '') ?>">
              <?= htmlspecialchars($v['name']) ?>
            </option>
          <?php endforeach; ?>
        </select>
      </div>

      <div class="col-md-6">
        <label class="form-label">Activity Name</label>
        <input type="text" class="form-control" placeholder="Temple Tour" required>
      </div>
      <div class="col-md-3">
        <label class="form-label">Base Price</label>
        <div class="input-group">
          <span class="input-group-text">THB</span>
          <input type="number" step="0.01" class="form-control" placeholder="0.00" required>
        </div>
      </div>
    </div>
    <div class="mt-3">
      <button class="btn btn-primary" type="submit"><i class="bi bi-save me-1"></i> Save (demo)</button>
      <span class="text-muted ms-2 small">Hook to real store later</span>
    </div>
  </form>
  <script>
  (function(){
    var countrySel = document.getElementById('countrySelect');
    var citySel = document.getElementById('citySelect');
    var vendorSel = document.getElementById('vendorSelect');
    if (!countrySel || !citySel || !vendorSel) return;

    var cityData = <?php echo json_encode($cities ?? []); ?>;

    function uniq(arr){
      var s = {}; var out = []; for (var i=0;i<arr.length;i++){ var v = (arr[i]||'').trim(); if (v!=='' && !s[v]){ s[v]=1; out.push(v); } } return out;
    }

    function fillCities(country){
      var list = cityData.filter(function(r){ return (r.country||'')===country; }).map(function(r){ return r.city||''; });
      list = uniq(list).sort();
      var html = '<option value="">-- Select City --</option>' + list.map(function(ci){ return '<option value="'+ci.replace(/"/g,'&quot;')+'">'+ci.replace(/</g,'&lt;')+'</option>'; }).join('');
      citySel.innerHTML = html;
      citySel.disabled = list.length === 0;
    }

    function filterVendors(){
      var c = countrySel.value || '';
      var ci = citySel.value || '';
      for (var i=0;i<vendorSel.options.length;i++){
        var opt = vendorSel.options[i];
        if (!opt.value) continue;
        var vc = (opt.getAttribute('data-country')||'');
        var vci = (opt.getAttribute('data-city')||'');
        var ok = true;
        if (c !== '' && vc !== c) ok = false;
        if (ok && ci !== '' && vci !== ci) ok = false;
        opt.hidden = !ok;
      }
      // If current selected vendor is hidden, reset selection
      var sel = vendorSel.selectedOptions.length ? vendorSel.selectedOptions[0] : null;
      if (sel && sel.hidden) vendorSel.value = '';
    }

    countrySel.addEventListener('change', function(){
      fillCities(countrySel.value || '');
      citySel.value = '';
      filterVendors();
    });
    citySel.addEventListener('change', filterVendors);
    // Initial filter (no country/city selected): show all hotel vendors
    filterVendors();
  })();
  </script>
</div>
