<?php
// app/Views/admin/airports_form.php
$editing = !empty($airport['id']);
$action = $editing ? '/admin/airports/update' : '/admin/airports/store';
?>
<div class="container py-3">
  <h2 class="h5 mb-3 d-flex align-items-center">
    <i class="bi bi-airplane me-2"></i>
    <?= $editing ? 'Edit Airport' : 'Add Airport' ?>
  </h2>

  <?php if (!empty($_SESSION['errors'])): ?>
    <div class="alert alert-danger py-2 small">
      <?php foreach ($_SESSION['errors'] as $e): ?><div><?= htmlspecialchars($e) ?></div><?php endforeach; unset($_SESSION['errors']); ?>
    </div>
  <?php endif; ?>

  <form method="post" action="<?= $action ?>" class="needs-validation" novalidate>
    <input type="hidden" name="csrf" value="<?= htmlspecialchars($csrf) ?>">
    <?php if ($editing): ?>
      <input type="hidden" name="id" value="<?= (int)$airport['id'] ?>">
    <?php endif; ?>

    <div class="row g-3">
      <div class="col-md-2">
        <label class="form-label">Code</label>
        <input type="text" name="code" value="<?= htmlspecialchars((string)($airport['code'] ?? '')) ?>" class="form-control form-control-sm" placeholder="BKK" required>
      </div>
      <div class="col-md-6">
        <label class="form-label">Name</label>
        <input type="text" name="name" value="<?= htmlspecialchars((string)($airport['name'] ?? '')) ?>" class="form-control form-control-sm" placeholder="Suvarnabhumi Airport" required>
      </div>
      <div class="col-md-2">
        <label class="form-label">City</label>
        <input type="text" name="city" value="<?= htmlspecialchars((string)($airport['city'] ?? '')) ?>" class="form-control form-control-sm" placeholder="Bangkok">
      </div>
      <div class="col-md-2">
        <label class="form-label">Country</label>
        <input type="text" name="country" value="<?= htmlspecialchars((string)($airport['country'] ?? '')) ?>" class="form-control form-control-sm" placeholder="Thailand">
      </div>
    </div>

    <div class="d-flex justify-content-between align-items-center gap-2 mt-3">
      <a class="btn btn-sm btn-secondary" href="/admin/airports">Cancel</a>
      <button class="btn btn-sm btn-primary"><?= $editing ? 'Save Changes' : 'Create Airport' ?></button>
    </div>
  </form>
</div>
