<?php

if (!function_exists('log_taxi_payment')) {
    /**
     * Log taxi payment related messages with timestamp and context
     * 
     * @param string $message The log message
     * @param array $context Additional context data
     * @param string $level Log level (error, info, debug)
     * @return void
     */
    function log_taxi_payment($message, $context = [], $level = 'info') {
        $logDir = __DIR__ . '/../../storage/logs/taxi_payments';
        
        // Create directory if it doesn't exist
        if (!file_exists($logDir)) {
            mkdir($logDir, 0755, true);
        }
        
        $logFile = $logDir . '/' . date('Y-m-d') . '.log';
        
        $timestamp = date('Y-m-d H:i:s');
        $contextStr = !empty($context) ? json_encode($context, JSON_PRETTY_PRINT) : '';
        
        $logMessage = "[$timestamp] [$level] $message" . PHP_EOL;
        if (!empty($contextStr)) {
            $logMessage .= "Context: " . $contextStr . PHP_EOL;
        }
        $logMessage .= str_repeat("-", 80) . PHP_EOL;
        
        // Write to log file
        file_put_contents($logFile, $logMessage, FILE_APPEND);
        
        // Also log to PHP error log for critical errors
        if ($level === 'error') {
            error_log("[TaxiPayment] $message - " . $contextStr);
        }
    }
}
