<?php
namespace App\Core;

class Router
{
    // Untyped properties for broader PHP compatibility on some servers
    private $routes = [];
    private $pdo;

    public function __construct(\PDO $pdo)
    {
        $this->pdo = $pdo;
    }

    public function get(string $path, string $action): void { $this->add('GET', $path, $action); }
    public function post(string $path, string $action): void { $this->add('POST', $path, $action); }

    private function add(string $method, string $path, string $action): void
    {
        $this->routes[$method][$path] = $action;
    }

    public function dispatch(): void
    {
        $uri = parse_url($_SERVER['REQUEST_URI'], PHP_URL_PATH);
        // Adjust for /public base if needed
        $base = rtrim(dirname($_SERVER['SCRIPT_NAME']), '/');
        if ($base && str_starts_with($uri, $base)) {
            $uri = substr($uri, strlen($base));
        }
        if ($uri === '') $uri = '/';
        // Normalize: remove trailing slashes except for root
        if ($uri !== '/') {
            $uri = rtrim($uri, '/');
        }
        $method = $_SERVER['REQUEST_METHOD'];

        $action = $this->routes[$method][$uri] ?? null;
        if (!$action) {
            http_response_code(404);
            echo '404 Not Found';
            return;
        }
        [$controller, $methodName] = explode('@', $action);
        $controllerClass = 'App\\Controllers\\' . $controller;
        if (!class_exists($controllerClass)) {
            http_response_code(500);
            echo 'Controller not found';
            return;
        }
        $instance = new $controllerClass($this->pdo);
        if (!method_exists($instance, $methodName)) {
            http_response_code(500);
            echo 'Action not found';
            return;
        }
        call_user_func([$instance, $methodName]);
    }
}
