<?php
namespace App\Core\Menu;

class AdminMenu
{
    /**
     * Build the admin top menu.
     *
     * Sections:
     * - Dashboard
     * - Booking: Add Activity Booking, Hotel Booking, Taxi Booking, Evisa Request
     * - Vendor Management: Add Vendor, Add vendor Activity, Hotel, Taxies, Evisa
     * - Tool: Country and currency
     * - Add Category
     * - Add Management: Add Agent, Add Channel Partner, Add Employee
     *
     * @return MenuItem[]
     */
    public static function items(): array
    {
        return [
            MenuItem::link('Dashboard', '/admin', 'bi bi-speedometer2'),
            MenuItem::group('Booking', [
                MenuItem::link('Hotels', '/admin/booking/hotel', 'bi bi-building'),
                MenuItem::link('Taxis', '/admin/booking/taxi', 'bi bi-taxi-front'),
                MenuItem::link('E‑Visas', '/admin/booking/evisa', 'bi bi-file-earmark-text'),
            ], 'bi bi-calendar-check'),
            MenuItem::group('Activity', [
                MenuItem::link('Add New Activity', '/admin/vendors/activity/create', 'bi bi-lightning'),
                MenuItem::link('Manage Activity Package', '/admin/vendors/package_manage', 'bi bi-gear'),
            ], 'bi bi-briefcase'),
            // Direct access to Hotels and Taxi management
            MenuItem::link('Hotels', '/admin/hotels', 'bi bi-building'),
            MenuItem::link('Yachts', '/admin/yachts', 'bi bi-tsunami'),
            // Packages (multi-night packages) near Yachts as requested
            MenuItem::link('Packages', '/admin/vendors/package_manage', 'bi bi-box-seam'),
            MenuItem::link('Taxis', '/admin/taxis', 'bi bi-taxi-front'),
            MenuItem::link('Wallet Secure', '/admin/wallet/secure', 'bi bi-shield-lock'),
            MenuItem::group('Wallet', [
                MenuItem::link('Deposits', '/admin/wallet/deposits', 'bi bi-wallet2'),
                MenuItem::link('Bank Accounts', '/admin/bank-accounts', 'bi bi-bank'),
            ], 'bi bi-wallet2'),
            MenuItem::link('Payments', '/admin/payments', 'bi bi-credit-card'),
            MenuItem::group('Team', [
                MenuItem::link('Agent List', '/admin/management/agents', 'bi bi-people'),
                MenuItem::link('Add Agent', '/admin/management/agents/create', 'bi bi-person-plus'),
                MenuItem::link('Channel Partner List', '/admin/management/partners', 'bi bi-people'),
                MenuItem::link('Add Channel Partner', '/admin/management/partners/create', 'bi bi-people'),
                MenuItem::link('Add Employee', '/admin/management/employees/create', 'bi bi-person-badge'),
                MenuItem::link('Add Customer', '/admin/management/customers/create', 'bi bi-person'),
                MenuItem::link('Unlock Agent Login', '/admin/security/agent/unlock', 'bi bi-unlock'),
            ], 'bi bi-people'),
            MenuItem::group('Tools', [
                // Vendors (moved above KYC)
                MenuItem::group('Vendors', [
                    MenuItem::link('Add Vendor', '/admin/vendors/create', 'bi bi-person-plus'),
                ], 'bi bi-person-plus'),

                // KYC section
                MenuItem::group('KYC', [
                    MenuItem::link('KYC Reviews', '/admin/kyc', 'bi bi-shield-check'),
                    MenuItem::link('KYC Settings', '/admin/settings/kyc', 'bi bi-gear'),
                ], 'bi bi-shield-lock'),

                // Settings section
                MenuItem::group('Settings', [
                    MenuItem::link('Country/Currency', '/admin/tools/country-currency', 'bi bi-geo'),
                    MenuItem::link('Modules', '/admin/categories/create', 'bi bi-tags'),
                    MenuItem::link('Payment Gateways', '/admin/tools/payment-gateways', 'bi bi-credit-card'),
                    MenuItem::link('Support Tickets', '/admin/support', 'bi bi-life-preserver'),
                ], 'bi bi-gear'),

                // Email & Templates
                MenuItem::group('Email', [
                    MenuItem::link('SMTP Settings (Legacy)', '/admin/settings/smtp', 'bi bi-envelope'),
                    MenuItem::link('Email Templates', '/admin/tools/email-templates', 'bi bi-envelope-open'),
                    // New system mail center
                    MenuItem::link('System Mail Settings', '/admin/settings/email', 'bi bi-gear'),
                    MenuItem::link('Email Logs', '/admin/logs/emails', 'bi bi-clipboard-data'),
                ], 'bi bi-envelope-open'),

                // Messaging
                MenuItem::group('Messaging', [
                    MenuItem::link('WhatsApp Settings', '/admin/settings/whatsapp', 'bi bi-whatsapp'),
                    MenuItem::link('WhatsApp Logs', '/admin/logs/whatsapp', 'bi bi-clipboard-data'),
                ], 'bi bi-chat-dots'),

                // Logs
                MenuItem::group('Logs', [
                    MenuItem::link('Audit Logs', '/admin/audit/logs', 'bi bi-clipboard-data'),
                    MenuItem::link('Security Audit', '/admin/audit/security', 'bi bi-shield-shaded'),
                ], 'bi bi-clipboard-data'),

                // Marketing
                MenuItem::group('Marketing', [
                    MenuItem::link('Promos', '/admin/promos', 'bi bi-megaphone'),
                ], 'bi bi-megaphone'),
            ], 'bi bi-tools'),
        ];
    }
}


