<?php
namespace App\Core\Mail\Providers;

use App\Core\Mail\ProviderInterface; 
use App\Core\Mail\Envelope; 
use App\Core\Mail\SendResult; 
use App\Core\Mail\SendGridClient;

class SendGridProvider implements ProviderInterface
{
    private SendGridClient $client;
    private array $profile;

    public function __construct(array $config)
    {
        $key = $config['sendgrid_api_key'] ?? (getenv('SENDGRID_API_KEY') ?: '');
        $this->client = new SendGridClient($key);
        $this->profile = $config;
    }

    public function send(Envelope $env): SendResult
    {
        $from = [ 'address' => $env->fromEmail ?? ($this->profile['from']['address'] ?? 'noreply@example.com'),
                  'name' => $env->fromName ?? ($this->profile['from']['name'] ?? '') ];
        $bcc = $env->bcc ?? [];
        $res = $this->client->sendHtml($env->to, $env->subject, $env->html, $from, $bcc);
        return new SendResult((bool)$res['ok'], (string)($res['message'] ?? ''), null, (int)($res['status'] ?? 0));
    }

    public function name(): string { return 'sendgrid'; }
}
