<?php
namespace App\Core\Mail;

class Envelope
{
    public string $to;
    public string $subject;
    public string $html;
    public string $altText;
    public ?string $fromEmail;
    public ?string $fromName;
    public array $bcc = [];

    public function __construct(string $to, string $subject, string $html, string $altText = '', ?string $fromEmail = null, ?string $fromName = null, array $bcc = [])
    {
        $this->to = $to; $this->subject = $subject; $this->html = $html; $this->altText = $altText;
        $this->fromEmail = $fromEmail; $this->fromName = $fromName; $this->bcc = $bcc;
    }
}

class SendResult
{
    public bool $ok; public string $message; public ?string $messageId; public int $status;
    public function __construct(bool $ok, string $message = 'Sent', ?string $messageId = null, int $status = 0)
    { $this->ok = $ok; $this->message = $message; $this->messageId = $messageId; $this->status = $status; }
}

interface ProviderInterface
{
    /**
     * @return SendResult
     */
    public function send(Envelope $env): SendResult;
    public function name(): string; // 'ses' | 'sendgrid' | 'smtp'
}
