<?php
namespace App\Core;

class Logger
{
    public static function info(string $action, array $ctx = []): void { self::write('INFO', $action, $ctx); }
    public static function error(string $action, array $ctx = []): void { self::write('ERROR', $action, $ctx); }
    public static function security(string $action, array $ctx = []): void { self::write('SECURITY', $action, $ctx); }

    private static function write(string $level, string $action, array $ctx): void
    {
        $ip = $_SERVER['REMOTE_ADDR'] ?? '';
        $line = sprintf("%s [%s] %s ip=%s ctx=%s\n", date('c'), $level, $action, $ip, json_encode($ctx));
        $logDir = dirname(__DIR__, 2) . '/storage/logs';
        if (!is_dir($logDir)) @mkdir($logDir, 0775, true);
        @file_put_contents($logDir . '/app.log', $line, FILE_APPEND);
    }
}
