<?php
namespace App\Core;

class Controller
{
    protected \PDO $pdo;

    public function __construct(\PDO $pdo)
    {
        $this->pdo = $pdo;
        Security::enforceIpAllowlist();
    }

    protected function view(string $template, array $data = []): void
    {
        extract($data);
        $view = new View();
        $view->render($template, $data);
    }

    protected function redirect(string $path): void
    {
        header('Location: ' . $path);
        exit;
    }
}
