<?php
namespace App\Controllers;

use App\Core\Auth;
use App\Core\Controller;
use App\Core\Security;

class HotelsController extends Controller
{
    public function index(): void
    {
        Auth::checkRole(['Admin','Employee','Vendor']);
        $hotels = $this->pdo->query('SELECT * FROM hotels ORDER BY id DESC')->fetchAll();
        $this->view('hotels/index', ['title' => 'Hotels', 'hotels' => $hotels]);
    }

    public function create(): void
    {
        Auth::checkRole(['Admin','Vendor']);
        $this->view('hotels/create', ['title' => 'Create Hotel']);
    }

    public function store(): void
    {
        Auth::checkRole(['Admin','Vendor']);
        if (!Security::verifyCsrf($_POST['csrf'] ?? '')) die('CSRF');
        $stmt = $this->pdo->prepare('INSERT INTO hotels (name, city, country, base_price, vendor_id) VALUES (:name, :city, :country, :base_price, :vendor_id)');
        $stmt->execute([
            'name' => $_POST['name'] ?? '',
            'city' => $_POST['city'] ?? '',
            'country' => $_POST['country'] ?? '',
            'base_price' => (float)($_POST['base_price'] ?? 0),
            'vendor_id' => (int)($_POST['vendor_id'] ?? 1),
        ]);
        header('Location: /hotels');
    }

    public function edit(): void
    {
        Auth::checkRole(['Admin','Vendor']);
        $id = (int)($_GET['id'] ?? 0);
        $stmt = $this->pdo->prepare('SELECT * FROM hotels WHERE id = :id');
        $stmt->execute(['id' => $id]);
        $hotel = $stmt->fetch();
        $this->view('hotels/edit', ['title' => 'Edit Hotel', 'hotel' => $hotel]);
    }

    public function update(): void
    {
        Auth::checkRole(['Admin','Vendor']);
        if (!Security::verifyCsrf($_POST['csrf'] ?? '')) die('CSRF');
        $stmt = $this->pdo->prepare('UPDATE hotels SET name=:name, city=:city, country=:country, base_price=:base_price WHERE id=:id');
        $stmt->execute([
            'id' => (int)($_POST['id'] ?? 0),
            'name' => $_POST['name'] ?? '',
            'city' => $_POST['city'] ?? '',
            'country' => $_POST['country'] ?? '',
            'base_price' => (float)($_POST['base_price'] ?? 0),
        ]);
        header('Location: /hotels');
    }

    public function delete(): void
    {
        Auth::checkRole(['Admin']);
        if (!Security::verifyCsrf($_POST['csrf'] ?? '')) die('CSRF');
        $stmt = $this->pdo->prepare('DELETE FROM hotels WHERE id=:id');
        $stmt->execute(['id' => (int)($_POST['id'] ?? 0)]);
        header('Location: /hotels');
    }
}
