<?php
namespace App\Controllers;

use App\Core\Controller;

class FileController extends Controller
{
    public function walletDeposit(): void
    {
        $id = (int)($_GET['id'] ?? 0);
        if ($id <= 0) { http_response_code(404); echo 'Not found'; return; }

        // Signed URL validation (expiring)
        $exp = isset($_GET['exp']) ? (int)$_GET['exp'] : 0;
        $sig = (string)($_GET['sig'] ?? '');
        $secret = function_exists('env') ? (string)env('APP_SECRET', 'dev-secret') : 'dev-secret';
        $base = $id . '|' . $exp;
        $calc = hash_hmac('sha256', $base, $secret);
        if (!hash_equals($calc, $sig)) { http_response_code(403); echo 'Invalid signature'; return; }
        if ($exp > 0 && time() > $exp) { http_response_code(403); echo 'Link expired'; return; }

        // Fetch request and proof path
        $st = $this->pdo->prepare('SELECT agent_user_id, proof_file FROM wallet_deposit_requests WHERE id = :id');
        $st->execute([':id'=>$id]);
        $row = $st->fetch(\PDO::FETCH_ASSOC);
        if (!$row || empty($row['proof_file'])) { http_response_code(404); echo 'Not found'; return; }

        // Authorization: agent can view own; admin (Admin/admin) can view any
        $isAdmin = (!empty($_SESSION['user']) && in_array(($_SESSION['user']['role'] ?? ''), ['Admin','admin'], true));
        $agentId = (int)($_SESSION['agent']['id'] ?? 0);
        if (!$isAdmin && $agentId !== (int)$row['agent_user_id']) { http_response_code(403); echo 'Forbidden'; return; }

        // Resolve filesystem path
        $rel = ltrim((string)$row['proof_file'], '/\\');
        $fs = dirname(__DIR__, 2) . DIRECTORY_SEPARATOR . $rel;
        if (!is_file($fs)) { http_response_code(404); echo 'File missing'; return; }

        // Content-Type detection
        $ext = strtolower(pathinfo($fs, PATHINFO_EXTENSION));
        $mime = 'application/octet-stream';
        $map = [
            'jpg'=>'image/jpeg','jpeg'=>'image/jpeg','png'=>'image/png','gif'=>'image/gif','webp'=>'image/webp','pdf'=>'application/pdf'
        ];
        if (isset($map[$ext])) $mime = $map[$ext];

        // Stream file
        $download = isset($_GET['download']) ? (int)$_GET['download'] : 0;
        header('Content-Type: ' . $mime);
        header('Content-Length: ' . filesize($fs));
        header('X-Content-Type-Options: nosniff');
        // Prevent indexing/caching of private files
        header('Cache-Control: private, no-store, no-cache, must-revalidate');
        if ($download === 1) {
            $safeName = 'wallet_slip_'.$id.'.'.$ext;
            header('Content-Disposition: attachment; filename="'.$safeName.'"');
        }
        readfile($fs);
        exit;
    }
}
