<?php
namespace App\Controllers;

use App\Core\Controller;
use App\Core\Auth;
use App\Core\Security;

class BookingController extends Controller
{
    public function activityCreate(): void
    {
        Auth::requireRole(['Admin']);
        // Only hotel vendors for this flow
        $vendors = $this->pdo->query("SELECT id, name, country, city FROM vendors WHERE module='hotel' ORDER BY name")->fetchAll();

        // Load countries and cities from your own database tables
        try {
            $countries = $this->pdo->query("SELECT DISTINCT country FROM locations WHERE country IS NOT NULL AND country<>'' ORDER BY country")->fetchAll();
        } catch (\Throwable $e) { $countries = []; }
        try {
            $cities = $this->pdo->query("SELECT country, city FROM locations WHERE city IS NOT NULL AND city<>'' ORDER BY country, city")->fetchAll();
        } catch (\Throwable $e) { $cities = []; }

        $csrf = Security::csrfToken();
        $this->view('admin/booking_activity_create', compact('vendors','countries','cities','csrf'));
    }

    public function hotel(): void
    {
        Auth::requireRole(['Admin']);
        $hotels = $this->pdo->query("SELECT h.id, h.name, h.city, h.country, v.name AS vendor FROM hotels h JOIN vendors v ON v.id=h.vendor_id ORDER BY h.id DESC LIMIT 50")->fetchAll();
        $this->view('admin/booking_hotel', compact('hotels'));
    }

    public function taxi(): void
    {
        Auth::requireRole(['Admin']);
        $taxis = $this->pdo->query("SELECT t.id, t.name, t.route, v.name AS vendor FROM taxis t JOIN vendors v ON v.id=t.vendor_id ORDER BY t.id DESC LIMIT 50")->fetchAll();
        $this->view('admin/booking_taxi', compact('taxis'));
    }

    public function evisa(): void
    {
        Auth::requireRole(['Admin']);
        $evisas = $this->pdo->query("SELECT e.id, e.country, e.base_price, v.name AS vendor FROM evisas e JOIN vendors v ON v.id=e.vendor_id ORDER BY e.id DESC LIMIT 50")->fetchAll();
        $this->view('admin/booking_evisa', compact('evisas'));
    }
}
