# B2B Travel Portal (Core PHP)

This is the initial scaffold for a modular, secure B2B travel portal in Core PHP + MySQL.

## Quick Start
1. Create database `b2b_travel` and import `database/schema.sql`.
2. Update DB credentials in `config/config.php`.
3. Configure web server document root to `public/`.
4. Create an admin user manually:
   ```sql
   INSERT INTO users (name, email, role, status, password_hash, api_enabled) VALUES
   ('Admin', 'admin@example.com', 'admin', 'active', PASSWORD('ChangeMe!'), 0);
   ```
   Note: Use PHP's password_hash instead of MySQL PASSWORD():
   ```php
   echo password_hash('ChangeMe!', PASSWORD_BCRYPT);
   ```
5. Login at `/login`.

## Next Steps
- Add Registration with OTP (Twilio + SMTP)
- Implement RBAC middleware and dashboards per role
- Wallet deposit/approval flows and ledger
- API token issuance and logging
- Booking modules (hotel, activity, taxi, visa, package)
- Security hardening (CSRF already present, add file upload validation, action logs)
